#!/usr/bin/env python
# coding=utf-8

import json
import random
import time

HOST = 'market-loyalty.tst.vs.market.yandex.net'
# пока данные по метрикам с белого маркета
average_user_session_duration_minutes = 6
average_user_session_depth = 5.66


class Counters:
    create_coin_counter = int(round(time.time() * 1000000000))

    def get_create_coin_counter(self):
        self.create_coin_counter += 1
        return self.create_coin_counter


# main method
def ammo(profile, ammo_period):
    sum_rps = sum([load[1] for load in profile])
    size = sum_rps * ammo_period

    ammo = []
    for (method_gen, rps, params) in profile:
        rate = float(rps) / sum_rps
        for _ in range(max(int(size * rate), 1)):
            if params is None:
                ammo.append(method_gen())
            else:
                ammo.append(method_gen(params))
    random.shuffle(ammo)

    for bullet in ammo:
        print(bullet)


# util method for generating ammo
def make_ammo(method, url, tag, headers='Host: %s' % HOST, body=None):
    '''
        Makes phantom ammo
        http://yandextank.readthedocs.org/en/latest/ammo_generators.html
    '''

    # http request w/o entity body template
    req_template = (
        "%s %s HTTP/1.1\n"
        "%s\n"
        "\n"
    )

    # http request with entity body template
    req_template_w_entity_body = (
        "%s %s HTTP/1.1\n"
        "%s\n"
        "Content-Type: application/json\n"
        "Content-Length: %d\n"
        "\n"
        "%s\n"
    )

    if not body:
        req = req_template % (method, url, headers)
    else:
        req = req_template_w_entity_body % (method, url, headers, len(body), body)

    # phantom ammo template
    ammo_template = (
        "%d %s\n"
        "%s"
    )

    return ammo_template % (len(req), tag, req)


baseUid = random.randint(1, 1000000000)
UIDS = (baseUid, baseUid + 1000000000)


def uid():
    return random.randint(UIDS[0], UIDS[1]), 'UID'


# methods

def subscription_request():
    email = "mail" + str(random.randint(0, 10000)) + "@yandex.ru"

    return '{"platform": "BLUE", "notificationType": "ADVERTISING", "region": "1000", "email": "%s"}' % email


def perk_status_with_unique_uid(unique_count):
    uid = random.randint(baseUid, baseUid + unique_count)
    return make_ammo('GET', '/perk/status/?perkType=yandex_plus&perkType=prime&uid=%s&regionId=213' % uid,
                     'PERK_STATUS PERK_STATUS_CACHE')


def perk_status_with_random_uid():
    uid = random.randint(UIDS[0], UIDS[1])
    return make_ammo('GET', '/perk/status/?perkType=yandex_plus&perkType=prime&uid=%s&regionId=213' % uid,
                     'PERK_STATUS PERK_STATUS_NO_CACHE')


feedIdOfferId = [
    ('5860', '7031'),
    ('212367', '1127'),
    ('401290', '2175463'),
    ('223867', '50230'),
    ('435411', '2543594'),
    ('435300', '2237037'),
    ('423267', '28406168'),
    ('318382', '3949841'),
    ('423267', '28389826'),
]

# coins by user_id
coinsInDb = {
    60: [24459, 24460, 24461, 24462, 24463],
    12088758: [25103, 25104],
    30233874: [25087, 25088],
    44650740: [25546],
    45524489: [25547, 23785, 23786, 23807, 23808],
    99846209: [25141, 25549, 25551, 25541, 25543],
    121203288: [19713, 19714, 27355, 27356],
    149276617: [25097, 25098, 25101, 25102, 25140],
    160149299: [16556, 16557],
    160400430: [14620, 14621, 14622, 14623],
    172299097: [10074, 10075, 16094, 16095, 10282],
    214523109: [25133, 25134, 25135, 25138, 25144],
    242133900: [25055, 25056, 25057, 25058, 25059],
    274027215: [25117, 25118, 25127, 25128, 25129],
    275389744: [17648, 17649],
    359299990: [25053, 25054],
    359875577: [10080, 10081, 10086, 10087, 10090],
    367210982: [25071, 25072, 25077, 25078, 25083],
    430586742: [25139, 25142, 25166, 25172, 25176],
    438619750: [17658, 17659, 25548, 25538],
    457551157: [16098, 16099, 14378, 14379, 16616],
    467561429: [25079, 25080],
    503196103: [23701, 23702],
    533393207: [18669, 18670, 18689, 18690],
    540661227: [14810, 14811, 15010, 15011, 16766],
    543379978: [13860, 13861, 14450, 14451],
    543646578: [25675],
    543646699: [27742],
    543646727: [25552],
    543646803: [25567],
    543647180: [16164, 16165, 14206, 14207, 17842],
    543647185: [17118, 17119, 27773, 27413],
    543647191: [17076, 17077, 17114, 17115, 17394],
    543647198: [14234, 14235, 14364, 14365, 14548],
    543647204: [14366, 14367, 27418, 27426, 27432],
    543647211: [14232, 14233, 10136, 10137, 14546],
    543647219: [17252, 17253, 18102, 18103, 27187],
    543647223: [13946, 13947, 16652, 16653, 16664],
    543647228: [16146, 16147, 16926, 16927, 25636],
    543647231: [10370, 10371, 10384, 10385, 16666],
    543647232: [10112, 10113, 13896, 13897, 14158],
    543647236: [10382, 10383, 15996, 15997, 14664],
    543647240: [10028, 10029, 10030, 10031, 10064],
    543647242: [16088, 16089, 13942, 13943, 14020],
    543647246: [16026, 16027, 14694, 14695, 14974],
    543647250: [14740, 14741, 16086, 16087, 16674],
    543647256: [10104, 10105, 16976, 16977, 17008],
    543647264: [16136, 16137, 14944, 14945, 16614],
    543647268: [17006, 17007, 18074, 18075, 19457],
    543647271: [17010, 17011, 17048, 17049, 18072],
    543647277: [14374, 14375, 17084, 17085, 17152],
    543647281: [17016, 17017, 17028, 17029, 17086],
    543647282: [16952, 16953],
    543647287: [14248, 14249, 17044, 17045, 17088],
    543647293: [17198, 17199, 18146, 18147, 18213],
    543647298: [17046, 17047, 17160, 17161, 18110],
    543647305: [16984, 16985, 17022, 17023, 17050],
    543647307: [14344, 14345, 14346, 14347, 14348],
    543647310: [10134, 10135, 14376, 14377, 16980],
    543647316: [17210, 17211, 27632, 27323],
    543647322: [16938, 16939, 17030, 17031, 17146],
    543647325: [16936, 16937, 17058, 17059, 17158],
    543647329: [16568, 16569, 16988, 16989, 17148],
    543647332: [18078, 18079, 27451],
    543647335: [16982, 16983],
    543647341: [17154, 17155, 25665],
    543647344: [10350, 10351],
    543647345: [16566, 16567, 16990, 16991, 17162],
    543647348: [17034, 17035, 17062, 17063],
    543647352: [17052, 17053, 17060, 17061, 17164],
    543647355: [10012, 10013, 14678, 14679, 18597],
    543647357: [17092, 17093, 17208, 17209, 17214],
    543647363: [16942, 16943, 17096, 17097, 17166],
    543647368: [17098, 17099, 17206, 17207, 25671],
    543647371: [10352, 10353],
    543647379: [16820, 16821],
    543647384: [25668],
    543647385: [14662, 14663],
    543647401: [17174, 17175],
    543647402: [10126, 10127, 13926, 13927, 10140],
    543647414: [16158, 16159, 10230, 10231, 13880],
    543647418: [10010, 10011, 10040, 10041, 10098],
    543647421: [16570, 16571, 17194, 17195],
    543647425: [10006, 10007, 10042, 10043, 16061],
    543647426: [25674],
    543647429: [13932, 13933, 10194, 10195, 10280],
    543647431: [25667],
    543647436: [16172, 16173, 10178, 10179, 10238],
    543647440: [10124, 10125, 10296, 10297, 14470],
    543647447: [10038, 10039, 10138, 10139, 15952],
    543647448: [16576, 16577],
    543647451: [10004, 10005, 10036, 10037, 10048],
    543647453: [16574, 16575],
    543647456: [10120, 10121, 16116, 16117, 16132],
    543647460: [10016, 10017, 16024, 16025, 16114],
    543647465: [10008, 10009, 10022, 10023, 16168],
    543647466: [16582, 16583],
    543647471: [10122, 10123, 16162, 16163, 13930],
    543647474: [16580, 16581]
}

# coins id from market_loyalty_load.discount
coin_list = [
    1198958, 1233483, 1234933, 1231822, 1198960, 1231829, 1234952, 1198978, 1231815, 1235740, 1236770, 1234934,
    1198985, 1198959, 1275681, 1244424, 1245250, 1243464, 1243341, 1242890, 1242888, 1242891, 1242889, 1240681,
    1240663, 1240604, 1234966, 1219486, 1219485, 1219511, 1132834, 1132775, 1132930, 1132870, 1132485, 1132629,
    1132785, 1132159, 1132418, 1132466, 1132480, 1132187, 1132273, 1132811, 1132652, 1132417, 1132338, 1132333,
    1132246, 1132171, 1132257, 1132179, 1132314, 1132491, 1132176, 1132467, 1132922, 1132908, 1132758, 1132769,
    1132704, 1132875, 1132331, 1132388, 1132428, 1132221, 1132313, 1132444, 1132842, 1132935, 1132902, 1132787,
    1132965, 1132694, 1132907, 1132956, 1132864, 1132651, 1132390, 1132885, 1132692, 1132569, 1132819, 1132628,
    1132986, 1132241, 1132165, 1132334, 1132321, 1132432, 1132471, 1132326, 1132294, 1132443, 1132263, 1132371,
    1132487, 1132429, 1132175, 1132413, 1132248, 1132169, 1132260, 1132238, 1132342, 1132227, 1132168, 1132356,
    1132250, 1132182, 1132475, 1132228, 1132195, 1132379, 1132346, 1132548, 1132600, 1132739, 1132685, 1132655,
    1132860, 1132559, 1132673, 1132891, 1132218, 1132747, 1132695, 1132735, 1132650, 1132987, 1132938, 1132523,
    1132501, 1132564, 1132973, 1132433, 1132593, 1132701, 1132635, 1132924, 1132511, 1132689, 1132383, 1132363,
    1132567, 1132731, 1132192, 1132484, 1132795, 1132705, 1132264, 1132336, 1132928, 1132861, 1132866, 1132937,
    1132570, 1132917, 1132292, 1132254, 1132436, 1132756, 1132328, 1132857, 1132691, 1132927, 1132274, 1132601,
    1132620, 1132862, 1132170, 1132594, 1132249, 1132424, 1132234, 1132189, 1132283, 1132259, 1132200, 1132407,
    1132163, 1132367, 1132414, 1132204, 1132207, 1132452, 1132226, 1132232, 1132270, 1132357, 1132365, 1132310,
    1132166, 1132330, 1132402, 1132303, 1132364, 1132297, 1132305, 1132473, 1132458, 1132490, 1132459, 1132180,
    1132450, 1132158, 1132282, 1132399, 1132205, 1132469, 1132229, 1132404, 1132461, 1132446, 1132353, 1132213,
    1132288, 1132384, 1132392, 1132247, 1132245, 1132343, 1132201, 1132393, 1132437, 1132374, 1132262, 1132210,
    1132242, 1132320, 1132255, 1132276, 1132716, 1132762, 1132971, 1132794, 1132298, 1132455, 1132174, 1132719,
    1132899, 1132521, 1132974, 1132883, 1132610, 1132963, 1132188, 1132621, 1132849, 1132844, 1132197, 1132397,
    1132289, 1132894, 1132909, 1132389, 1132711, 1132627, 1132552, 1132771, 1132745, 1132498, 1132224, 1132797,
    1132608, 1132837, 1132666, 1132514, 1132670, 1132581, 1132209, 1132300, 1132697, 1132878, 1132235, 1132547,
    1132662, 1132508, 1132372, 1132468, 1132751, 1132976, 1132445, 1132520, 1132911, 1132813, 1132381, 1132451,
    1132349, 1132299, 1132181, 1132400, 1132505, 1132823, 1132355, 1132198, 1132324, 1132329, 1132489, 1132223,
    1132888, 1132744, 1132354, 1132463, 1132194, 1132350, 1132344, 1132592, 1132847, 1132658, 1132337, 1132411,
    1132676, 1132713, 1132410, 1132674, 1132708, 1132944, 1132335, 1132435, 1132322, 1132217, 1132162, 1132377,
    1132901, 1132728, 1132477, 1132161, 1132419, 1132315, 1132423, 1132565, 1132536, 1132506, 1132493, 1132272,
    1132325, 1132993, 1132405, 1132644, 1132688, 1132777, 1132386, 1132476, 1132293, 1132368, 1132360, 1132206,
    1132185, 1132442, 1132406, 1132378, 1132173, 1132430, 1132265, 1132251, 1132327, 1132295, 1132233, 1132427,
    1132359, 1132258, 1132199, 1132323, 1132253, 1132186, 1132479, 1132302, 1132196, 1132281, 1132309, 1132403,
    1132167, 1132208, 1132279, 1132440, 1132317, 1132164, 1132401, 1132286, 1132492, 1132422, 1132211, 1132266,
    1132244, 1132453, 1132339, 1132269, 1132220, 1132284, 1132341, 1132240, 1132296, 1132481, 1132178, 1132347,
    1132421, 1132203, 1132362, 799449, 1132256, 1132449, 1132308, 1132447, 808784, 1132483, 1132316, 1132472,
    1132332, 1132457, 1132352, 1132438, 1132416, 1132361, 1132287, 838480, 1132184, 1132177, 841365, 838561,
    1132478, 1132366, 1132426, 1132439, 1132280, 1132348, 1132431, 1132275, 1123849, 1132464, 1132271, 1132306,
    1132395, 1132369, 1132285, 1132448, 1132434, 1132376, 1132236, 1132277, 1132291, 1132225, 1132215, 1132190,
    1132456, 1132214, 1132398, 1132191, 1132408, 1132267, 1132231, 1132156, 1132462, 1132465, 1132202, 1132391,
    1132319, 1132252, 1132387, 1132441, 1132304, 1132394, 1132396, 1132193, 1132425, 1132382, 1132172, 1132318,
    1132913, 1132641, 1132409, 1132268, 1132216, 1132373, 1132230, 1132307, 1132157, 1132340, 1132482, 1132412,
    1132420, 1132278, 1132237, 1132741, 1132532, 1132518, 1132290, 1132380, 1132726, 1132874, 1132616, 1132239,
    1132920, 1132768, 1132375, 1132486, 1132385, 1132784, 1132470, 1132555
]

sku = [
    100131946582, 100136953867, 100126174523, 100131946302, 100126175001, 100126173313, 100131945348, 100131945347,
    100126174439, 100131945562, 100131945569, 100131944769, 100126175073, 100131946442, 100126173331, 100126174668,
    14112254, 100131946652, 100126174719, 100131946265, 100126175026, 100131945999, 100126174656, 100131945326,
    100126175113, 1759379111, 100131946257, 100131946515, 100131946117, 100126173303, 100126174770, 100126174814,
    100126174837, 100126174619, 100131945863, 100126175084, 100126175091, 100131945624, 100131945637, 100185501529,
    100131946571, 100126174861, 100126174620, 100131946236, 100131945386, 100131946474, 100126174857, 100131945715,
    100126174858, 100131945714, 100131946276, 100126174971, 100126174557, 100131945862, 100131945991, 100131945758,
    100126173343, 100126174679, 100131945571, 100136953859, 100131946277, 100131945851, 100131945870, 100126174505,
    100126174780, 100131946504, 100131945275, 100126174815, 100131945369, 100131945579, 100131946159, 0, 100175283582,
    100198127239, 100126174987, 100126175043, 100131945990, 100131946605, 100126174816, 100131945998, 100126174817,
    100131945997, 100131945510, 100126175950, 100131946278, 100131946331, 100131945489, 100126174534, 100126174569,
    100131946158, 100131946524, 100131945730, 100131945775, 100131945525, 100131945765, 100131945749, 100126174475,
    100126174037, 100126174039, 100126175129, 100131946060, 100131946061, 100126175121, 100131945480, 100131945759,
    100198027239, 100126174745, 100126174955, 100126174989, 100126174979, 100131945475, 100131946371, 100131945935,
    100131945917, 100131946604, 100175266359, 100131945324, 100126174707, 12607332, 100126174715, 100126174473,
    100131945632, 100126174988, 100131945755, 100131945351, 100126173329, 100131946440, 100131946441, 100131945359,
    100131946684, 100126174474, 100131946262, 100131946572, 100131946332, 100131946566, 100131945479, 100126175019,
    100131945934, 100131945933, 100131945932, 100257133916, 100131946263, 100131946576, 100131946066, 100131946067,
    100131946068, 100131945463, 100126175074, 100131945784, 100131945300, 100131945783, 100131945782, 100131945540,
    100131946069, 100126174489, 100131946290, 100131946292, 100131946054, 100131946056, 100126175100, 100131945685,
    100131945276, 100131946360, 100131945864, 100131946041, 100131946043, 100131946167, 100126174708, 100126175165,
    100131946291, 100131946130, 100131946131, 100131946135, 100131946221, 1759379118, 1718537336, 100131946288,
    100131946169, 100126175159, 100126176009, 100131945818, 100131945817, 100131945856, 100126174506, 100131946567,
    100126174542, 100136953869, 100131945816, 100126175156, 100126175155, 100131945824, 100131944733, 100126175160,
    100131946558, 100131945696, 100131946322, 100126175183, 100126174709, 100131946350, 100131946584, 100126174785,
    100126174924, 100126174720, 100131945831, 100131946311, 100126174571, 100131946636, 100131944816, 100131945716,
    100126174887, 100126173315, 100126174888, 100126174647, 100131946458, 100131945823, 100126173830, 100126174964,
    100131946146, 100126175017, 100126175018, 100126175099, 100131945785, 100131946147, 100131945519, 100131946696,
    100136953871, 100131945812, 100131945631, 100126174788, 100131946554, 100131946393, 100131946155, 100131946399,
    100126175009, 8457179, 100126175000, 100131946168, 100126174956, 100131945478, 100131945462, 1712539807,
    100131946546, 100126174572, 100131945676, 100126175036, 100126175039, 13021321, 14112219, 100126175167,
    100126175166, 100131946390, 100131946391, 100126175123, 100131945774, 100131945524, 100126174813, 100131946688,
    100131946376, 100131946689, 100131946668, 100285223746, 100131946377, 100131945822, 100126174776, 100131945474,
    100126175083, 100126174787, 100126174546, 100126174792, 100131946134, 100126174427, 100131946076, 100126175168,
    100131945811, 100131946677, 100131945466, 100126174553, 100126174554, 100131946548, 100131946306, 100126174597,
    100126174598, 100126175179, 100126174722, 100126174981, 100131945472, 100131946320
]


# all_coins = reduce(list.__add__, coinsInDb.values())


def discount_request(identity_id):
    price = str(random.randint(1500, 100000))
    order_id = random.randint(100, 100000)

    fo_id = random.choice(feedIdOfferId)
    offer_id = fo_id[1]
    feed_id = fo_id[0]
    quantity = str(random.randint(1, 10))
    phone = str(random.randint(10000000000, 90000000000))

    coin_ids = coinsInDb[identity_id] if identity_id in coinsInDb else []
    coins = []
    for i in coin_ids:
        coins.append({"id": i})

    request = {
        "operationContext": {
            "ip": "127.0.0.1",
            "ipRegion": "213",
            "regionId": "213",
            "shopId": 0,
            "uid": 0,
            "userAgent": "curl",
            "yandexUid": "1234567",
            "phone": phone
        },
        "orders": [{
            "orderId": order_id,
            "cartId": order_id,
            "platform": "BLUE",
            "paymentType": "SHOP_PREPAID",
            "deliveries": [
                {
                    "id": "asdasdasd",
                    "type": "COURIER",
                    "price": 300,
                    "selected": True,
                    "region": 213
                }
            ],
            "items": [
                {
                    "atSupplierWarehouse": False,
                    "offerId": offer_id,
                    "feedId": feed_id,
                    "price": price,
                    "supplierId": 0,
                    "quantity": quantity,
                    "hyperCategoryId": 12312,
                    "sku": "123123",
                    "vendorId": 0,
                    "deliveryPartnerTypes": [
                        "YANDEX_MARKET"
                    ],
                }
            ]
        }],
        "platform": "BLUE",
        "coins": coins
    }

    return json.dumps(request)


def prep_coin_object(c_id):
    return {"id": c_id}


def get_sku():
    i = random.randint(0, len(sku) - 1)
    return sku[i]


def prep_items():
    cnt = random.randint(1, 5)
    result = []
    for i in range(0, cnt):
        result.append(prep_item())
    return result


def prep_item():
    price = str(random.randint(1500, 100000))
    fo_id = random.choice(feedIdOfferId)
    offer_id = fo_id[1]
    feed_id = fo_id[0]
    quantity = str(random.randint(1, 10))
    return {
        "atSupplierWarehouse": False,
        "offerId": offer_id,
        "feedId": feed_id,
        "price": price,
        "supplierId": 0,
        "quantity": quantity,
        "hyperCategoryId": 12312,
        "sku": str(get_sku()),
        "vendorId": 0,
        "deliveryPartnerTypes": [
            "YANDEX_MARKET"
        ],
    }


def discount_request_hard_mode(identity_id):
    order_id = random.randint(100, 100000)

    phone = str(random.randint(10000000000, 90000000000))

    coin_count = random.randint(0, len(coin_list) - 1)

    coin_amount = random.randint(5, 10)
    coins = []
    for i in range(0, coin_amount):
        coins.append(prep_coin_object(coin_list[random.randint(0, coin_count)]))

    request = {
        "operationContext": {
            "ip": "127.0.0.1",
            "ipRegion": "213",
            "regionId": "213",
            "shopId": 0,
            "uid": 0,
            "userAgent": "curl",
            "yandexUid": "1234567",
            "phone": phone
        },
        "orders": [{
            "orderId": order_id,
            "cartId": order_id,
            "platform": "BLUE",
            "paymentType": "SHOP_PREPAID",
            "deliveries": [
                {
                    "id": "asdasdasd",
                    "type": "COURIER",
                    "price": 300,
                    "selected": True,
                    "region": 213
                }
            ],
            "items": prep_items()

        }],
        "platform": "BLUE",
        "coins": coins
    }

    return json.dumps(request)


def random_offers_request(max_size):
    offers = []
    for i in range(random.randint(1, max_size)):
        offers.append(random_offer())
    return offers


def random_offer():
    return {
        "feedId": random.randint(10000, 100000),
        "offerId": str(random.randint(10000, 100000)),
        "quantity": random.randint(1, 10),
        "price": random.randint(1000, 10000)
    }


def discount_calc(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('POST', '/discount/calc/v3?couponCode=COUPON_FOR_LOAD', 'CALC',
                     body=discount_request(user_id))


def discount_calc_hard_mode(user_id):
    return make_ammo('POST', '/discount/calc/v3?couponCode=COUPON_FOR_LOAD', 'CALC-HEAVY',
                     body=discount_request_hard_mode(user_id))


def discount_spend(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('POST', '/dontUseInProduction/spendDiscountWithCoinCreation?couponCode=COUPON_FOR_LOAD', 'SPEND',
                     body=discount_request(user_id))


def coins_cart(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('POST', '/coins/cart?uid=%s' % user_id, 'COINS_CART',
                     body='{"items":[{"offerId":"65","feedId":200321470,"price":1000,"quantity":1}]}')


def coins_cart_white(user_id_gen):
    user_id, user_id_type = user_id_gen()
    random_feed = random.randint(10000, 100000)
    random_offer_id = str(random.randint(10000, 100000))
    return make_ammo('POST', '/coins/cart/WHITE/v2?regionId=213&clientDeviceType=DESKTOP&uid=%s' % user_id,
                     'COINS_CART_WHITE',
                     body='{{"items":[{{"offerId":"{}","feedId":{},"count":1}}]}}'.format(random_offer_id, random_feed))


def bind_coin():
    return make_ammo('PUT', '/dontUseInProduction/bindCoinsToUserWithCoinCreation', 'BIND_COIN',
                     body=None)


def coins_person(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('GET', '/coins/person?uid=%s&limitFutureCoins=5' % user_id, 'COINS_PERSON',
                     body=None)


def active_coins_count(user_id_gen):
    user_id, user_id_type = user_id_gen()
    # curl -X GET "http://market-loyalty.tst.vs.market.yandex.net:35815/coins/getActiveCoinsCount?uid=4031460710"
    # -H "accept: application/json"
    return make_ammo('GET', '/coins/getActiveCoinsCount?uid=%s' % user_id, 'ACTIVE_COINS_COUNT',
                     body=None)


def ping():
    # curl -X GET "http://market-loyalty.tst.vs.market.yandex.net:35815/ping" -H "accept: */*"
    return make_ammo('GET', '/ping', 'PING',
                     body=None)


def welcome_check(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('POST', '/welcome/v2/check', 'WELCOME_CHECK',
                     body=welcome_check_request(user_id))


def cashback_options(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('POST', '/cashback/options?uid=%s&regionId=213' % user_id, 'CASHBACK_OPTIONS',
                     body=cashback_options_request())


def notifications_status(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('GET', '/notifications/status?uid=%s' % user_id, 'NOTIFICATIONS_STATUS',
                     body=None)


def price_left_for_free_delivery():
    return make_ammo('POST',
                     '/discount/priceLeftForFreeDelivery/v2?regionId=213&clientDeviceType=DESKTOP&'
                     'perks=YANDEX_PLUS&perks=YANDEX_CASHBACK&platform=BLUE',
                     'FREE_DELIVERY_V2',
                     body=discount_price_left_for_free_delivery_request())


def price_left_for_free_delivery_v3():
    return make_ammo('POST',
                     '/discount/priceLeftForFreeDelivery/v3?regionId=213&clientDeviceType=DESKTOP&'
                     'perks=YANDEX_PLUS&perks=YANDEX_CASHBACK&platform=BLUE',
                     'FREE_DELIVERY_V3',
                     body=discount_price_left_for_free_delivery_request())


def pumpkin_perk_status():
    uid = random.randint(UIDS[0], UIDS[1])
    return make_ammo('GET', '/pumpkin/perk/status?perkType=yandex_plus&uid=%s&regionId=213' % uid,
                     'PUMPKIN_PERK_STATUS')


def promocode_activate(user_id_gen):
    user_id, user_id_type = user_id_gen()
    request = {
        "userId": user_id,
        "codes": ["feb23"]
    }
    return make_ammo('POST', '/promocodes/v1/activate', 'PROMO_ACTIVATE', body=json.dumps(request))


def subscriptions_plus_notify(user_id_gen):
    user_id, user_id_type = user_id_gen()
    return make_ammo('POST', '/subscriptions/plus/notify?uid=%s' % user_id, 'SUBSCRIPTIONS_PLUS_NOTIFY',
                     body=discount_price_left_for_free_delivery_request())


def get_coin(coins):
    return make_ammo('GET', '/coins/coin?coinId=%s' % random.choice(coins), 'GET_COIN',
                     body=None)


def discount_calc_coupon_plus_coin(uids):
    user_id = uids[random.randint(0, len(uids) - 1)]
    return make_ammo('POST', '/discount/calc/v3?couponCode=COUPON_FOR_LOAD', 'CALC_COUPON_PLUS_COINS',
                     body=discount_request(user_id))


def discount_calc_coin(uids):
    user_id = uids[random.randint(0, len(uids) - 1)]
    return make_ammo('POST', '/discount/calc/v3', 'CALC_COINS',
                     body=discount_request(user_id))


def order_status_updated_without_checkouter():
    request = {
        "platform": "BLUE",
        "orderId": 123,
        "orderStatus": "PROCESSING",
        "paymentType": "PREPAID",
        "noAuth": False,
        "uid": 60,
        "userPhoneNumber": "89991113344",
        "userEmail": "test@test.ru",
        "deliveryRegion": 213,
        "userName": "user",
        "items": [
            {"feedId": 100, "offerId": "100", "categoryId": 734595, "price": 15000, "count": 1, "msku": 100}
        ]
    }
    return make_ammo('POST', '/dontUseInProduction/completeOrderStatusUpdated',
                     'ORDER_STATUS_UPDATED_WITHOUT_CHECKOUTER', body=json.dumps(request))


def order_status_updated_with_checkouter():
    request = {
        "platform": "BLUE",
        "orderId": 123,
        "orderStatus": "PROCESSING",
        "paymentType": "PREPAID",
        "noAuth": False,
        "uid": 60,
        "userPhoneNumber": "89991113344",
        "userEmail": "test@test.ru",
        "deliveryRegion": 213,
        "userName": "user",
        "items": [
            {"feedId": 100, "offerId": "100", "categoryId": 734595, "price": 15000, "count": 1, "msku": 100}
        ]
    }
    return make_ammo('POST', '/dontUseInProduction/completeOrderStatusUpdatedWithCheckouter',
                     'ORDER_STATUS_UPDATED_WITH_CHECKOUTER', body=json.dumps(request))


# def brand_day_promo_group_get_brand_day_groups():
#     return make_ammo('GET',
#                      '/promoGroup/brandDay/groups',
#                      'getBrandDayPromoGroups')


# def brand_day_promo_group_get_brand_day_promos_today():
#     return make_ammo('GET',
#                      '/promoGroup/brandDay/promos/today',
#                      'getBrandDayPromosToday')


def get_promo_group_by_tokens():
    ids = [
        'NEZABUDNI-1',
        'NEZABUDNI-2',
        'NEZABUDNI-3',
        'NEZABUDNI-4',
        'NEZABUDNI-5',
    ]
    return get_promo_group_by_token(ids[random.randint(0, len(ids) - 1)])


def get_promo_group_by_token(token):
    return make_ammo('GET',
                     '/promo/byPromoGroupToken?promoGroupToken=%s&promoGroupType=BRAND_DAY' % token,
                     'PROMO_BY_PROMO_GROUP_TOKEN')


def get_promo_by_codes():
    ids = [
        'daily-monday',
        'daily-tuesday',
        'daily-wednesday',
        'daily-thursday',
        'daily-friday',
        'daily-sunday',
        'daily-saturday'
    ]
    return get_promo_by_code(ids[random.randint(0, len(ids) - 1)])


def get_promo_by_code(code):
    return make_ammo('GET', '/promo/byCode/?code=%s' % code, 'PROMO_BY_CODE')


def get_promo_coin_info_by_ids():
    promo_ids = [107367, 107366, 107365, 107364, 107363, 107362, 107335, 99614, 99613, 99612, 99611, 99610, 99609,
                 99606, 99605, 99604, 99138, 99137, 99136, 99085, 99084, 99083, 99081, 99080, 99079, 98976, 98975,
                 98974, 98973, 98791, 97352, 97352, 97352, 97352, 97351, 97350, 97066, 97066, 97066, 97066, 22056,
                 22056, 22056, 20814, 20394, 20394, 20375, 20374, 20277, 20276, 20276, 20273, 20272, 20227, 20226,
                 20225, 20224, 20223, 20222, 20221, 20220, 20219, 20218, 20217, 20216, 20215, 20214, 20213, 20212,
                 20211, 20210, 20209, 20209, 20208, 20208, 20198]
    # for p in promo_ids :
    #     result += brand_day_promo_get_get_promo_coin_info(p)
    # return result
    return get_promo_coin_info(promo_ids[random.randint(0, len(promo_ids) - 1)])


def get_promo_coin_info(code):
    return make_ammo('GET', '/promo/coin/%s' % code, 'PROMO_COIN_INFO')


# def brand_day_promo_get_get_brand_day_dates():
#     return make_ammo('GET',
#                      '/promoGroup/brandDay/dates',
#                      'getBrandDayDates')


def promos_by_uid_and_promo_group_token():
    request = {
        "promoGroupTokenAndTypeList": [
            {"token": "NEZABUDNI-1", "promoGroupType": "BRAND_DAY"},
            {"token": "NEZABUDNI-2", "promoGroupType": "BRAND_DAY"},
            {"token": "NEZABUDNI-3", "promoGroupType": "BRAND_DAY"},
            {"token": "NEZABUDNI-4", "promoGroupType": "BRAND_DAY"},
            {"token": "NEZABUDNI-5", "promoGroupType": "BRAND_DAY"}
        ],
        "uid": 185756309
    }

    return make_ammo('POST',
                     '/promo/byPromoGroupToken/list',
                     'PROMO_LIST_BY_PROMO_GROUP_TOKEN', body=json.dumps(request))


cntr = Counters()


def create_coin_v2_by_counter():
    coin_counter = cntr.get_create_coin_counter()
    # for i in range(coin_counter, coin_counter+1):
    #     result += brand_day_promo_post_create_coin_v2(i)

    return create_coin_v2(coin_counter)


def create_coin_v2(ids):
    request = {
        "uid": "%s" % ids,
        "idempotencyKey": "%s" % ids
    }
    return make_ammo('POST', '/coins/createCoin/v2?promoId=%s&reason=ORDER' % 107362,
                     'CREATE_COIN_V2', body=json.dumps(request))


def welcome_check_request(identity_id):
    request = {
        "regionId": 213,
        "uid": identity_id
    }

    return json.dumps(request)


def cashback_options_request():
    price = str(random.randint(1500, 100000))
    order_id = random.randint(100, 100000)
    fo_id = random.choice(feedIdOfferId)
    offer_id = fo_id[1]
    feed_id = fo_id[0]
    quantity = str(random.randint(1, 10))

    request = {
        "orders": [
            {
                "cartId": "string",
                "orderId": order_id,
                "platform": "BLUE",
                "items": [
                    {
                        "cashbackRequest": {
                            "promoKey": "testPromoKey",
                            "version": 0
                        },
                        "offerId": offer_id,
                        "feedId": feed_id,
                        "price": price,
                        "quantity": quantity,
                        "discount": 0,
                        "hyperCategoryId": 0,
                        "oldMinPrice": 0,
                        "sku": "string",
                        "vendorId": 0,
                        "warehouseId": 0,
                        "atSupplierWarehouse": True,
                        "supplierId": 0,
                        "shopSku": "string",
                        "bundleId": "testBundleId",
                        "cashback": {
                            "promoKey": "string",
                            "version": 0
                        },
                        "deliveryPartnerTypes": [
                            "string"
                        ],
                        "loyaltyProgramPartner": True,
                        "platform": "BLUE"
                    }
                ]
            }
        ]
    }

    return json.dumps(request)


def discount_price_left_for_free_delivery_request():
    fo_id = random.choice(feedIdOfferId)
    offer_id = fo_id[1]
    feed_id = fo_id[0]
    quantity = str(random.randint(1, 10))

    request = {
        "items": [
            {
                "feedId": feed_id,
                "offerId": offer_id,
                "bundleId": "test_bundle_id",
                "count": quantity
            }
        ]
    }

    return json.dumps(request)


############################################################

status_rps = 2700  # 694.1
calc_rps = 110  # 26.3
promocode_activate_rps = 50
spend_rps = 3
# coins_bind_rps = 0.1
# coins_cart_rps = 6
coins_cart_white_rps = 38
# coins_person_rps = 1
# coins_get_rps = 8  # 7.3
coins_count_rps = 300  # 243.155
# ping_rps = 107  # 107.190
welcome_rps = 25  # 29.1
cashback_options_rps = 100  # 26.2
notifications_status_rps = 0.5  # 23.6
discount_price_left_for_free_delivery_rps = 0.5  # 14.2
discount_price_left_for_free_delivery_v3_rps = 0.5  # 14.2
pumpkin_perk_status_rps = 0.1

# brand_day_promo_group_get_brand_day_groups_rps = 0.1
# brand_day_promo_group_get_brand_day_promos_today_rps = 0.1
get_promo_group_by_token_rps = 250
get_promo_by_code_rps = 15
get_promo_coin_info_rps = 1
# brand_day_promo_get_get_brand_day_dates_rps = 0.1
find_promos_by_uid_and_promo_group_token_rps = 20
create_coin_v2_rps = 5
discount_calc_hard_mode_rps = 0.05


status_ttl = 10 * 60

max_ttl = status_ttl

cache_hit_ratio = (average_user_session_depth - 1) / average_user_session_depth

# подход с воспроизведением нужного cache_hit_ratio пока не проверен,
# надо при первой возможности проверить по логам после стрельбы
status_cache_hit_rps = cache_hit_ratio * status_rps
status_cache_miss_rps = status_rps - status_cache_hit_rps

# по этим юзерам кеш всегда будет свежим
status_unique_users = status_cache_hit_rps * status_ttl / 5

# для штучной генерации, например в релизные стрельбы
complex_profile = [
    (perk_status_with_random_uid, status_cache_miss_rps, None),
    (perk_status_with_unique_uid, status_cache_hit_rps, int(status_unique_users)),
    (discount_calc, calc_rps, uid),
    (active_coins_count, coins_count_rps, uid),
    # (ping, ping_rps, None),
    (welcome_check, welcome_rps, uid),
    (coins_cart_white, coins_cart_white_rps, uid),
    (cashback_options, cashback_options_rps, uid),
    (notifications_status, notifications_status_rps, uid),
    (price_left_for_free_delivery, discount_price_left_for_free_delivery_rps, None),
    (price_left_for_free_delivery_v3, discount_price_left_for_free_delivery_v3_rps, None),
    (promocode_activate, promocode_activate_rps, uid),
    (pumpkin_perk_status, pumpkin_perk_status_rps, None),
    # (get_coin, coins_person_rps, all_coins)
    (discount_calc_hard_mode, discount_calc_hard_mode_rps, uid),
    (create_coin_v2_by_counter, create_coin_v2_rps, None),
    (promos_by_uid_and_promo_group_token, find_promos_by_uid_and_promo_group_token_rps, None),
    (get_promo_coin_info_by_ids, get_promo_coin_info_rps, None),
    (get_promo_by_codes, get_promo_by_code_rps, None),
    (get_promo_group_by_tokens, get_promo_group_by_token_rps, None),
]

# для генерации патронов по текущим rps
capacity_load_gens = {
    'status_using_get': (perk_status_with_random_uid, None),                    # /perk/status
    'get_coins_count_for_person_using_get': (active_coins_count, uid),          # /coins/getActiveCoinsCount
    'calculate_cashback_profiles_using_post': (cashback_options, uid),          # /cashback/options
    'calculate_multi_cart_with_bundles_using_post': (discount_calc, uid),       # /discount/calc/v3
    'get_promo_group_by_token_using_get': (get_promo_group_by_tokens, None),    # /promo/byPromoGroupToken
    'for_cart_requesting_report_using_post_1': (coins_cart_white, uid),         # /coins/cart/WHITE/v2
    # 'save_promocodes_using_post': NO AMMO                             # /store/{user_type}/{user_id}/promocodes
    'activate_using_post': (promocode_activate, uid),                           # /promocodes/v1/activate
    # 'list_secret_sale_promos_for_user_using_get': NO AMMO                     # /loyalty-programs/byUid/{uid}
    'check_using_post_1': (welcome_check, uid),                                 # /welcome/v2/check
    # 'bind_coins_to_user_using_put_1': NO AMMO                                 # /coins/bind
    'get_promo_by_code_using_get': (get_promo_by_codes, None),                  # /promo/byCode
    'create_coin_v2_using_post': (create_coin_v2_by_counter, None),             # /coins/createCoin/v2
    # 'orders_status_updated_and_get_coins_using_post': NO AMMO                 # /coins/ordersStatusUpdatedAndGetCoins
    # 'for_person_using_get': NO AMMO                                           # /coins/person/{color}
    # 'get_all_coins_for_order_using_get': NO AMMO                              # /ocrm/coins/order/{orderId}
    # 'get_coins_for_order_using_get': NO AMMO                                  # /coins/forOrder/{orderId}
    # 'get_structured_cashback_using_post': NO AMMO                             # /cashback/getStructuredCashback
    # 'spend_multi_cart_with_bundles_using_post': NO AMMO                       # /discount/spend/v3
    # 'remove_promocodes_using_post': NO AMMO                           # /store/{user_type}/{user_id}/promocodes/remove
    # LESS THAN 1 RPS:
    'get_coin_promo_info_using_get': (get_promo_coin_info_by_ids, None),        # /promo/coin
    'find_promos_by_uid_and_promo_group_token_using_post': (promos_by_uid_and_promo_group_token, None),  # fpbuapgt
    'pumpkin_status_using_get': (pumpkin_perk_status, None),                    # /pumpkin/perk/status
    'price_left_for_free_delivery_v2_using_post': (price_left_for_free_delivery, None),  # /priceLeftForFreeDelivery
    # 'price_left_for_free_delivery_v3_using_post: (price_left_for_free_delivery_v3, None), NO RPS
    # ('', ''): (discount_calc_hard_mode, None), NO PAGE_ID
}

# specific_brand_day = [
# (brand_day_promo_group_get_brand_day_groups, brand_day_promo_group_get_brand_day_groups_rps, None),
# (brand_day_promo_group_get_brand_day_promos_today, brand_day_promo_group_get_brand_day_promos_today_rps, None),
# (brand_day_promo_get_get_brand_day_dates, brand_day_promo_get_get_brand_day_dates_rps, None),
# ]

# ammo(complex_profile, ammo_period=max_ttl * 2)

# uncomment to print ammo to stdout
# ammo(complex_profile, ammo_period=2)

# ammo(specific_brand_day, 400000)
