from database import Database
from sandbox import sdk2
from event_inserter import EventInserter
from sandbox.projects.common.binary_task import deprecated as binary_task
import logging as log


class MarketNotifierLoadTest(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)
        frequency_seconds = sdk2.parameters.Float("Frequency", default_value=0.1)  # 1 / 10
        batch_size = sdk2.parameters.Integer("Batch size", default_value=11)
        duration_seconds = sdk2.parameters.Integer("Duration", default_value=3600)
        average_size_kb = sdk2.parameters.Integer("Average message size in KB", default_value=4)
        db_name = sdk2.parameters.String("DB name", default_value="market_checkouter_prod")
        db_username = sdk2.parameters.String("DB username", default_value="market_checkouter")
        db_password_vault_owner = sdk2.parameters.String('DB password OWNER in Vault', default_value='MARKET')
        db_password_vault_name = sdk2.parameters.String('DB password NAME in Vault',
                                                        default_value='checkouter_load_db_password')
        db_host = sdk2.parameters.String("DB host", default_value="sas-cly1hsv1shkv06r8.db.yandex.net")
        db_port = sdk2.parameters.Integer("DB port", default_value=6432)

    def on_execute(self):
        log.info("Starting on_execute")
        binary_task.LastBinaryTaskRelease.on_execute(self)

        db = Database(
            self.Parameters.db_name,
            self.Parameters.db_username,
            self.Parameters.db_host,
            self.Parameters.db_port
        )
        password = sdk2.Vault.data(self.Parameters.db_password_vault_owner, self.Parameters.db_password_vault_name)
        with db.connect(password) as conn:
            log.debug("Connect to db", conn)
            EventInserter(
                conn,
                batch_size=self.Parameters.batch_size,
                frequency_seconds=self.Parameters.frequency_seconds,
                duration_seconds=self.Parameters.duration_seconds,
                average_size_kb=self.Parameters.average_size_kb
            ).do_work()

        log.info("Ending on_execute")
