import logging as log


class Database:
    def __init__(self, dbname, user, host, port):
        self.dbname = dbname
        self.user = user
        self.host = host
        self.port = port
        log.info("Database instance for credentials", dbname, user, host, port)

    def connect(self, password):
        import psycopg2

        return psycopg2.connect(
            dbname=self.dbname,
            user=self.user,
            password=password,
            host=self.host,
            port=self.port
        )
