USE marketclickhouse;

SELECT http_method as http_method,
       method as method,
       count() / (11 * 60 * 60) as rps
FROM market.push_api
WHERE date = today() - 1
AND NOT (url LIKE '/ping')
AND marketEnvironmentProfile = 'standard'
AND toHour(toDateTime(timestamp)) BETWEEN 12 AND 22
GROUP BY http_method, method
ORDER BY rps DESC
;
