import random

HOST = 'push-api.load.vs.market.yandex.net'


# main method
def ammo(profile, ammo_period):
    sum_rps = sum([load[1] for load in profile])
    size = sum_rps * ammo_period

    ammo = []
    for (method_gen, rps, params) in profile:
        rate = float(rps) / sum_rps
        for _ in range(max(int(size * rate), 1)):
            if params is None:
                ammo.append(method_gen())
            else:
                ammo.append(method_gen(params))
    random.shuffle(ammo)

    for bullet in ammo:
        print(bullet)


# util method for generating ammo
def make_ammo(method, url, tag, headers='Host: %s' % HOST, body=None):
    '''
        Makes phantom ammo
        http://yandextank.readthedocs.org/en/latest/ammo_generators.html
    '''

    # http request w/o entity body template
    req_template = (
        "%s %s HTTP/1.1\n"
        "%s\n"
        "\n"
    )

    # http request with entity body template
    req_template_w_entity_body = (
        "%s %s HTTP/1.1\n"
        "%s\n"
        "Content-Type: application/xml\n"
        "Content-Length: %d\n"
        "\n"
        "%s\n"
    )

    if not body:
        req = req_template % (method, url, headers)
    else:
        req = req_template_w_entity_body % (method, url, headers, len(body), body)

    # phantom ammo template
    ammo_template = (
        "%d %s\n"
        "%s"
    )

    return ammo_template % (len(req), tag, req)


def cart():
    from library.python import resource
    body = resource.find('sandbox/projects/market/checkout/MarketPushApiLoadGenerateAmmo/cart_body.xml')

    return make_ammo('POST', '/shops/431782/cart?context=MARKET&apiSettings=PRODUCTION&uid=575955533',
                     'shops_shopId_cart', body=body)


GENERATORS = {
    ('POST', 'shops_shopId_cart'): cart
}

if __name__ == '__main__':
    print(cart())
