import requests
import logging as log
import json

REQUEST_FAILED__FORMAT = 'Request {} {} failed: {} {}'

PAUSE_REQUEST = {
    "type": "PAUSE_ACTIONS",
    "content": {
        "comment": "Stop actions, running performance tests."
    }
}

RESUME_REQUEST = {
    "type": "RESUME_ACTIONS",
    "content": {
        "comment": "Performance tests finished, resume actions."
    }
}


class NannyClient:
    def __init__(self, task, token):
        self.add_task_info = task.set_info
        self.token = token

    def pause_actions(self, serivice_name):
        self.post_event(serivice_name, PAUSE_REQUEST)

    def resume_actions(self, serivice_name):
        self.post_event(serivice_name, RESUME_REQUEST)

    def post_event(self, serivice_name, data_object):
        resp = requests.post("http://nanny.yandex-team.ru/v2/services/{}/events/".format(serivice_name),
                             data=json.dumps(data_object),
                             headers={'Authorization': 'OAuth {}'.format(self.token),
                                      'Content-Type': 'application/json'})
        if resp.status_code != 202:
            self.log_error_response(resp)

    def log_error_response(self, res):
        msg = REQUEST_FAILED__FORMAT.format(res.request.method, res.url, res.status_code, res.text)
        self.add_task_info(msg)
        log.error(msg)


if __name__ == '__main__':
    log.basicConfig(level=log.DEBUG)
    NannyClient('').pause_actions('testing_market_checkouter_load_iva')
    NannyClient('').resume_actions('testing_market_checkouter_load_iva')
