from sandbox import sdk2
from pusher import Pusher


class PushToSolomon(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_api_url = sdk2.parameters.String('Solomon api url', default='http://solomon.yandex.net')
        project_id = sdk2.parameters.String('Project id')
        service_name = sdk2.parameters.String('Service name')
        cluster_name = sdk2.parameters.String('Cluster name')
        oauth_token_vault_key = sdk2.parameters.String('Oauth token vault key',
                                                       default='market_checkouter_solomon_oauth_token')
        sensor_label = sdk2.parameters.String('Sensor label')
        value = sdk2.parameters.Float('Value')

    def on_execute(self):
        oauth_token = sdk2.Vault.data('MARKET', self.Parameters.oauth_token_vault_key)

        pusher = Pusher(solomon_api_url=self.Parameters.solomon_api_url,
                        oauth_token=oauth_token,
                        project_id=self.Parameters.project_id,
                        service_name=self.Parameters.service_name,
                        cluster_name=self.Parameters.cluster_name)
        pusher.push_single_sensor(self.Parameters.sensor_label, self.Parameters.value)
