import logging as log


def query_clickhouse(yql_token, query_resource_path):
    from yql.api.v1.client import YqlClient
    from yql.client.operation import YqlOperationType
    client = YqlClient(token=yql_token)

    from library.python import resource
    rps = resource.find(query_resource_path)
    request = client.query(rps, syntax_version=1)
    request.type = YqlOperationType.CLICKHOUSE
    request.run()
    request.wait_progress()
    result = request.get_results()
    log.debug('YQL request: ' + str(request))
    log.debug('YQL result: ' + str(result))
    rows = []
    for res in result:
        res.fetch_full_data()
        for row in res.rows:
            rows.append(row)
    return rows
