# coding=utf-8

import logging
import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry

def get_delivery_id(checkouter_url, user_id, shop_id, feed_id, offer_id, fee_show, delivery_type):
    req = '{0}/cart?uid={1}&rgb=BLUE'.format(checkouter_url, user_id)

    headers = {'Content-Type': 'application/json',
               'X-Hit-Rate-Group': 'UNLIMIT'}

    payload = u'''{
        "buyerRegionId": %d,
        "buyerCurrency": "RUR",
        "carts": [
            {
                "shopId": %s,
                "items": [
                    {
                        "feedId": %s,
                        "offerId": "%s",
                        "showInfo": "%s",
                        "count": 1
                    }
                ],
                "delivery" : {
                    "regionId" : %d,
                    "address" : {
                        "country" : "Россия",
                        "postcode" : "119313",
                        "city" : "Санкт-Петербург",
                        "subway" : "Проспект Вернадского",
                        "street" : "Ленинский проспект",
                        "house" : "90",
                        "floor" : "6"
                    }
                }
            }
        ]
    }''' % (213, shop_id, feed_id, offer_id, fee_show, 213)

    logging.info("Getting delivery id: %s", req)
    logging.info("Payload: %s", payload)

    retry_strategy = Retry(
        total=10,
        status_forcelist=[429, 500, 502, 503, 504],
        method_whitelist=["HEAD", "GET", "OPTIONS"]
    )
    adapter = HTTPAdapter(max_retries=retry_strategy)
    session = requests.Session()
    session.mount("https://", adapter)
    session.mount("http://", adapter)

    get_delivery_id_answ = session.post(
        req, data=payload.encode('utf-8'), headers=headers)
    if get_delivery_id_answ.status_code != 200:
        logging.info(get_delivery_id_answ.headers)
        raise Exception('Failed to get delivery id. {} {}'.format(get_delivery_id_answ.status_code,
                                                                  get_delivery_id_answ.text))

    delivery_id = None
    for delivery in get_delivery_id_answ.json()['carts'][0]['deliveryOptions']:
        if delivery['type'] != delivery_type:
            continue
        delivery_id = delivery['id']
        if delivery_type == 'PICKUP':
            outlet = '"outletId": ' + str(delivery['outlets'][0]['id'])
        elif delivery['type'] == 'DELIVERY':
            outlet = u'''
                "address": {
                    "country": "Русь",
                    "postcode": "131488",
                    "city": "Питер",
                    "subway": "Петровско-Разумовская",
                    "street": "Победы",
                    "house": "13",
                    "block": "666",
                    "entrance": "404",
                    "entryphone": "007",
                    "floor": "8",
                    "apartment": "303",
                    "recipient": "000",
                    "phone": "02"
                }
            '''
        break
    if not delivery_id:
        raise Exception('no delivery id in get delivery id answer')

    return (delivery_id, outlet)
