import collections
import logging as log
import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry


def get_offer(report_url, shop_id, datafeed_id):
    req = '{0}/yandsearch'.format(report_url)
    params = {
        'place': 'offerinfo',
        'feed_shoffer_id': str(datafeed_id) + '-*',
        'fesh': shop_id,
        'rids': 213,
        'regset': 1,
        'pp': 18,
        'adult': 1,
        'rgb': 'blue',
        'show-preorder': 1
    }
    log.info("requesting report: %s", req)
    log.info("with params: %s", str(params))

    retry_strategy = Retry(
        total=10,
        status_forcelist=[429, 500, 502, 503, 504],
        method_whitelist=["HEAD", "GET", "OPTIONS"]
    )
    adapter = HTTPAdapter(max_retries=retry_strategy)
    session = requests.Session()
    session.mount("https://", adapter)
    session.mount("http://", adapter)

    report_answ = session.get(req, params=params).json(object_pairs_hook=collections.OrderedDict)

    log.info("report answer: %s", report_answ)

    offer = None
    for candidate in report_answ['search']['results']:
        if "supplier" in candidate and candidate['supplier']['id'] != "10264645" and candidate['feeShow']:
            offer = candidate
            break

    if not offer:
        raise Exception('offer not found!')

    log.info("offer: %s", offer)
    return offer


if __name__ == "__main__":
    report_url = 'http://warehouse-report.blue.tst.vs.market.yandex.net:17051'
    shop_id = 431782
    datafeed_id = 200344277
    for i in range(10):
        print(get_offer(report_url, shop_id, datafeed_id))
