import logging
import requests


class Solomon(object):
    def __init__(self,
                 oauthToken,
                 solomonUrl='https://solomon.yandex-team.ru'):
        self.solomonUrl = solomonUrl
        self.headers = {"Authorization": "OAuth " + oauthToken, "Content-Type": "application/json"}

    def __make_project_url(self, projectId):
        return "{solomon_url}/api/v2/projects/{project_id}/dashboards".format(
            solomon_url=self.solomonUrl,
            project_id=projectId
        )

    def __make_url(self, projectId, dashboardId):
        return "{solomon_url}/api/v2/projects/{project_id}/dashboards/{dashboard_id}".format(
            solomon_url=self.solomonUrl,
            project_id=projectId,
            dashboard_id=dashboardId
        )

    def get_dashboard(self, projectId, dashboardId):
        url = self.__make_url(projectId, dashboardId)

        resp = requests.get(url, headers=self.headers)

        if resp.status_code == requests.codes.not_found:
            return None
        elif resp.status_code == requests.codes.ok:
            return resp.json()
        else:
            raise Exception('Unable to get dashboard, status_code: ' + str(resp.status_code))

    def create_dashboard(self, projectId, dashboardId, body):
        body['id'] = dashboardId

        resp = requests.post(self.__make_project_url(projectId), headers=self.headers, json=body)

        if resp.status_code != requests.codes.ok:
            logging.debug('result: %s', resp.content)
            raise Exception('Exception unable to update dashboard, status_code: ' + str(resp.status_code))

    def update_dashboard(self, projectId, dashboardId, body):
        resp = requests.put(self.__make_url(projectId, dashboardId), headers=self.headers, json=body)

        if resp.status_code != requests.codes.ok:
            logging.debug('result: %s', resp.content)
            raise Exception('Exception unable to update dashboard, status_code: ' + str(resp.status_code))
