# coding: utf-8

"""Экспорт инфы о бешушных постоматах (локеров) в YT.
Потребитель - человек)
"""

from sandbox import sdk2
from sandbox.projects.common.binary_task import deprecated as binary_task


class ExportBeruLockersToYt(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        yt_token = sdk2.Vault.data('MARKET-IDX', 'MARKET-IDX-PRODUCTION-YT-TOKEN')

        from market.combinator.tools.export_to_yt.lib import export_beru_lockers_from_sandbox
        export_beru_lockers_from_sandbox(token=yt_token)
