# coding: utf8

import logging
import os

from sandbox import sdk2


def get_latest_resource(resource_type, **kwargs):
    return sdk2.Resource.find(resource_type=resource_type, **kwargs).order(-sdk2.Resource.id).first()


class MARKET_NORDSTREAM_FOR_DWH_APP(sdk2.Resource):
    """Бинарь `nordstream_for_dwh` для запуска в sandbox.
    """
    releasable = True
    releasers = ['MARKET']


class ExportNordstreamForDWH(sdk2.Task):
    """https://wiki.yandex-team.ru/market/development/combinator/nordstream/
    """
    def on_execute(self):
        logging.info('started')

        yt_token = sdk2.Vault.data('MARKET-IDX', 'MARKET-IDX-PRODUCTION-YT-TOKEN')

        app_resource_id = get_latest_resource(MARKET_NORDSTREAM_FOR_DWH_APP)
        app_tar_path = str(sdk2.ResourceData(app_resource_id).path)
        args = [
            'tar',
            '-xzf',
            app_tar_path,
        ]
        sdk2.helpers.subprocess.check_call(args)

        env = os.environ.copy()
        env.update({
            'YT_TOKEN': yt_token,
        })
        for spec in ['prod', 'test']:
            with sdk2.helpers.ProcessLog(self, logger='run.'+spec) as pl:
                sdk2.helpers.subprocess.check_call(
                    [
                        './nordstream_for_dwh',
                        '-spec', spec,
                    ],
                    env=env,
                    stdout=pl.stdout,
                    stderr=pl.stderr,
                    close_fds=True,
                    # cwd='./',
                )
        logging.info('finished')
