# -*- coding: utf-8 -*-
import os
from sandbox import sdk2
from .find_resource import find_resource


class RunCommandWithResources(sdk2.Task):
    """Run arbitrary shell script using some resources

    Resources are defined as "key1=value1 key2=value2 ..." string. Available keys/values correspond to sandbox.web.api.v1.resource.ResourceList.Get
    (see https://sandbox.yandex-team.ru/media/swagger-ui/index.html#/resource/resource_list_get)

    Vault items will be stored as environment variables.
    """

    class Parameters(sdk2.Task.Parameters):
        command = sdk2.parameters.String("Command to execute; resources may be used as '{key}'", required=True)
        resources = sdk2.parameters.Dict("Resources as a key-value pairs")
        vault_items = sdk2.parameters.Dict("Vault items to put in the environment")

    def on_execute(self):
        resources = {}
        for k, v in self.Parameters.resources.items():
            resources[k] = find_resource(v)

        command_env = os.environ.copy()
        for k, v in self.Parameters.vault_items.items():
            command_env[k] = sdk2.Vault.data(v)

        command = self.Parameters.command.format(**resources)
        with sdk2.helpers.ProcessLog(self, logger="command") as pl:
            sdk2.helpers.subprocess.check_call(
                command,
                env=command_env,
                shell=True,
                stdout=pl.stdout,
                stderr=pl.stderr,
                close_fds=True
            )
