import logging
from sandbox import sdk2
from sandbox.common.types.resource import State as ResourceState


def _find_braced_end(string, start, braces="{}"):
    if string[start] != braces[0]:
        raise ValueError("embraced sequence doesn't start with '{}'".format(braces[0]))

    cntr = 1
    i = start + 1
    while i < len(string) and cntr > 0:
        if string[i] == braces[1]:  # closing brace
            cntr -= 1
        elif string[i] == braces[0]:  # opening brace
            cntr += 1
        i += 1

    if cntr != 0:
        raise RuntimeError("broken embraced sequence ({} unclosed braces): {}".format(cntr, string[start:]))

    return i  # symbol after braced sequence


def _parse_kv(x, i, dst):
    j = x.index("=", i)
    key = x[i:j]

    j = j + 1
    k = (
        _find_braced_end(x, j) if x[j] == "{"
        else x.find(" ", j)
    )
    if k == -1:
        k = len(x)
    val = x[j:k]

    dst[key] = val
    return k


def parse_query(string):
    res = {}

    i = 0
    while i < len(string):
        if string[i].isspace():
            i += 1
            continue
        i = _parse_kv(string, i, res)

    return res


def find_resource(query):
    params = {
        "state": ResourceState.READY  # search only for READY resources by default
    }
    params.update(parse_query(query))

    if "type" in params:
        params["resource_type"] = sdk2.Resource[params["type"]]
        del params["type"]
    if "task_id" in params:
        params["task"] = params["task_id"]
        del params["task_id"]
    if "state" in params:
        params["state"] = getattr(ResourceState, params["state"])

    logging.info("Search for resource with {}...".format(params))
    resource = sdk2.Resource.find(**params).order(-sdk2.Resource.id).first()  # take the latest if there are a few
    if resource is None:
        raise RuntimeError("resource with {} not found".format(params))

    logging.info("Found {} resource (ID={})".format(resource.type, resource.id))
    return str(sdk2.ResourceData(resource).path)
