# -*- coding: utf-8 -*-
from sandbox import sdk2
from .update_resource_attrs import update_resource_attrs


class UpdateResourceAttributes(sdk2.Task):
    """
    Ищет последний Ресурс по ResourseType и проставляет этому ресурсу аттрибуты
    """

    class Parameters(sdk2.Task.Parameters):
        resource_type = sdk2.parameters.String("Resource type", required=True)
        filter_attrs = sdk2.parameters.Dict("Filter by resources attrs as a key-value pairs. By default take latest.")
        attrs = sdk2.parameters.Dict("Upsert Attrs of resource as a key-value pairs", required=True)
        sandbox_token = sdk2.parameters.Vault("Vault secret contains OAuth token; should provide access to Sandbox", required=True)

    def on_execute(self):
        resource_type = self.Parameters.resource_type
        attrs = self.Parameters.attrs
        filter_attrs = self.Parameters.filter_attrs
        sandbox_token = self.Parameters.sandbox_token.data()

        update_resource_attrs(
            resource_type=resource_type,
            attrs_filter=filter_attrs,
            attrs_update=attrs,
            sandbox_token=sandbox_token
        )
