# -*- coding: utf-8 -*-
import requests
import logging

SANDBOX_URL='https://sandbox.yandex-team.ru/api/v1.0'


def request_get_resource_id(resource_type, auth_headers, attrs_filter):
    attrs = dict(attrs_filter)
    attrs = str(attrs).replace('\'', '\"').replace('u"', '"')

    response = requests.get(
        "{}/resource".format(SANDBOX_URL),
        params={
            'limit': 1,
            'type': resource_type,
            'state': 'READY',
            'attrs': attrs,
        },
        headers=auth_headers)
    if not response.ok:
        raise Exception('{} {}'.format(attrs, response.text))
    return response.json()["items"][0]["id"]


def request_update_attr(resource_id, attr, auth_headers):
    response = requests.post(
        "{}/resource/{}/attribute".format(SANDBOX_URL, resource_id),
        json=attr,
        headers=auth_headers)
    # logging.info('create: ', response.text or 'ok')
    if not response.ok and response.reason == 'CONFLICT':
        response = requests.put(
            "{}/resource/{}/attribute/{}".format(SANDBOX_URL, resource_id, attr['name']),
            json=attr,
            headers=auth_headers)
        # logging.info('update: ', response.text or 'ok')


def update_resource_attrs(resource_type, attrs_filter, attrs_update, sandbox_token):
    auth_headers = {'Authorization': 'OAuth '+sandbox_token}
    attrs_list = []
    for k, v in attrs_update.items():
        attrs_list.append({'name': k, 'value': v})

    resource_id = request_get_resource_id(resource_type, auth_headers, attrs_filter)
    # logging.info('resource_id', resource_id)

    for attr in attrs_list:
        request_update_attr(resource_id, attr, auth_headers)
