#! /usr/bin/env python
# don't forget to run deploy.sh after PR was merged

import logging as log

from sandbox import sdk2
from sandbox.projects.common.binary_task import deprecated as binary_task

from sandbox.projects.market.contentApi.lib import capacity_task as ct


class MarketAntifraudCapacityMetrics(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)
        solomon_token = sdk2.parameters.String(label='Solomon token', default='CONTENT-API-SOLOMON-TOKEN')

    def on_execute(self):
        log.info('Starting on_execute')
        solomon_token = self.Parameters.solomon_token
        task = ct.CapacityTask(solomon_token=solomon_token)
        task.run()
