# coding: utf-8

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess
import sandbox.common.types.client as ctc
from sandbox import common


class MarketContentApiRunCommand(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX

    class Parameters(sdk2.Task.Parameters):

        command = sdk2.parameters.String(
            "Команда",
            required=True
        )

    def on_execute(self):

        with sdk2.helpers.ProcessLog(self, logger="command") as pl:
            pl.logger.propagate = 1
            retcode = subprocess.Popen(
                str(self.Parameters.command), shell=True, stdout=pl.stdout, stderr=subprocess.STDOUT
            ).wait()
        if retcode:
            raise common.errors.SubprocessError("process exited with non-zero return code {}".format(retcode))
