# coding: utf-8

import os
import logging
import json
from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk.environments import PipEnvironment


class MarketContentExpectedOrdersForecast(sdk2.Resource):
    executable = False
    ttl = 7


class MarketExpectedOrdersForecast(sdk2.Task):
    """
    Расчёт ожидаемого количества заказов в час
    """

    class Requirements(sdk2.Requirements):
        environments = (
            PipEnvironment('yandex-yt'),
            PipEnvironment('yql'),)
        cores = 1
        ram = 1024

        class Caches(sdk2.Requirements.Caches):
            pass  # Do not use any shared caches (required for running on multislot agent)

    class Parameters(sdk2.Task.Parameters):

        yt_token = sdk2.parameters.YavSecret(
            'Token for yql request',
            default='sec-01fn8sxmpc6f9qng8yjt4t830a'
        )

    def on_execute(self):
        from yql.api.v1.client import YqlClient

        secret = self.Parameters.yt_token.data()
        token = secret["token"]

        yql_client = YqlClient(token=token)

        with open(os.path.join(os.path.dirname(os.path.abspath(__file__)), 'query.yql')) as file:
            yql_query =  file.read()

        query = yql_client.query(yql_query, syntax_version=1)
        query.run()

        res = query.get_results()
        if not res.is_success:
            logging.error('Operation failed. Status:', res.status)
            if res.errors:
                for error in res.errors:
                    logging.error(' - %s', str(error))
            raise common.errors.TaskFailure('YQL query failed')

        result = {}
        result['forecast']=[]
        for table in query.get_results():
            table.fetch_full_data()

            rows = table.rows
            keys = [key for key, _ in table.columns]
            result['forecast'] = [
                dict(zip(keys, row))
                for row in rows
            ]

        filename = 'forecast.json'

        with open(filename, 'w') as file:
            file.write(json.dumps(result))

        logging.info('Creating resource %s in path: %s', MarketContentExpectedOrdersForecast.type, filename)

        resource = sdk2.ResourceData(MarketContentExpectedOrdersForecast(
            self, 'Market expected orders forecast', filename
        ))

        resource.ready()
