# coding: utf-8

import logging
import tarfile
from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus

# Статусы релизов обрабатываемые задачей
RELEASE_STATUSES = [ReleaseStatus.TESTING, ReleaseStatus.PRESTABLE, ReleaseStatus.STABLE]


class ReleaseStatusParam(sdk2.parameters.String):
    """
    Параметр для выбора статуса релиза 'stable', 'prestable', 'testing'
    """
    choices = list((_, _) for _ in RELEASE_STATUSES)
    required = True

    @classmethod
    def cast(cls, value):
        assert value in RELEASE_STATUSES
        return value


def untar(tar_path, destination, strip=0):
    """
    Разархивируем tar
    :param tar_path: путь к tar файлу
    :param destination: путь куда будет выдано содержимое архива
    :param strip: сколько верхних уровней в пути архивного элемента нужно обрезать
    :return: имя папки верхнего уровня в архиве если такая существует и все элементы в неё вложены (исключая файлы), иначе raise ValueError
    """
    logging.info('Unarchive tar file "{}" to "{}"'.format(tar_path, destination))
    tar = tarfile.open(tar_path)
    try:
        res = None
        for member in tar:
            m_path = sdk2.path.Path(member.path)

            if strip:
                ln = len(m_path.parts)
                m_path = sdk2.path.Path(*m_path.parts[(strip if ln > strip else ln-1):])
                member.path = str(m_path)

            root = m_path.parts[0]
            if root == member.path and not member.isdir():
                #ignore root files
                continue

            if res is None:
                res = root
            elif res != root:
                raise ValueError('untar unsupport multidirectory root tar: "{}" is not in root'.format(member.path))
        tar.extractall(path=destination)
        logging.info('Archive extracted successfully to "{}"'.format(destination))
        logging.info('res="{}"'.format(res))
        return res
    finally:
        tar.close()

