from datetime import datetime, timedelta

import sandbox.projects.market.contentApi.lib.capacity_utils as cap


class CapacityTask:

    def __init__(self, solomon_token):
        self._solomon_token = solomon_token

    def run(self):
        solomon_checkouter = cap.solomon_checkouter(self._solomon_token)
        solomon_af = cap.solomon_af(self._solomon_token)
        now = datetime.now()
        orders_capacity = \
            self._get_orders_capacity(solomon_af=solomon_af, solomon_checkouter=solomon_checkouter, now=now)
        cap.push_orders_capacity(solomon=solomon_af, capacity=orders_capacity, ts=now)
        forecast_from = now - timedelta(days=45)
        orders_forecast = cap.get_orders_forecast(solomon=solomon_checkouter, date_from=forecast_from)
        dau_forecast = cap.get_dau_forecast(solomon=solomon_checkouter, date_from=forecast_from)
        cap.push_orders_forecast(solomon=solomon_af, forecast=orders_forecast, ts=now)
        cap.push_dau_forecast(solomon=solomon_af, forecast=dau_forecast, ts=now)
        conversion = orders_forecast / dau_forecast
        dau_capacity = int(orders_capacity / conversion)
        cap.push_dau_capacity(solomon_af, capacity=dau_capacity, ts=now)

    def _get_orders_capacity(self, solomon_af, solomon_checkouter, now):
        order_rps_ratios = []
        for i in range(7):
            date_to = now - timedelta(days=i + 1)
            date_from = date_to - timedelta(days=1)
            rps = cap.get_rps_quantile(solomon=solomon_af, date_from=date_from, date_to=date_to, quantile=0.98)
            orders = cap.get_orders_count(solomon=solomon_checkouter, date_from=date_from, date_to=date_to)
            if orders is None or rps is None:
                continue
            if rps > 0 and orders > 0:
                order_rps_ratios.append(orders / rps)
        if len(order_rps_ratios) == 0:
            raise Exception('No data found for rps or order count')
        avg_orders_rps_ratio = sum(order_rps_ratios) / len(order_rps_ratios)
        capacity_rps = cap.get_af_last_shoot_result(solomon=solomon_af, date_from=now - timedelta(days=7))
        return int(avg_orders_rps_ratio * capacity_rps)
