import logging
from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.common.types.misc import NotExists
from sandbox.projects.market.content_storage import CsDataCreator

from sandbox.projects.common import binary_task
from sandbox.projects.common.ya_deploy import release_integration


class MarketCsDataLauncher(release_integration.ReleaseToYaDeployTask2, binary_task.LastBinaryTaskRelease, sdk2.Task):
    _SUBTASK_WAIT_TIMEOUT_SECONDS = 3600
    _release_title = 'Release CsDataCreator'

    class Parameters(CsDataCreator.MarketCsDataCreator.Parameters):
        pass

    def on_execute(self):
        with self.memoize_stage.launch_creator:
            logging.info('Start launcher')
            self._run_creator()

        logging.info('Check CsDataCreator task')

        if self.Context.creator_task_id is not NotExists:
            child = sdk2.Task[self.Context.creator_task_id]
            self.Parameters.task_status = child.Parameters.task_status
            self.Parameters.has_data_prepared = child.Parameters.has_data_prepared
            if child.status == ctt.Status.SUCCESS:
                logging.info('CsDataCreator task status: {}'.format(child.Parameters.task_status))
                if child.Parameters.has_data_prepared:
                    logging.info('Release CsDataCreator task')
                    self.server.release(
                        task_id=self.Context.creator_task_id,
                        type=ctt.ReleaseStatus.STABLE,
                        subject=self._release_title
                    )
                else:
                    logging.info("CsDataCreator task hasn't data prepared")
            else:
                logging.error("CsDataCreator task has been finished with status {}".format(child.status))
        else:
            logging.error("CsDataCreator task id missed")

        logging.info('Launcher has been finised')

    def _run_creator(self):
        logging.info('Init CsDataCreator task')
        creator_task = CsDataCreator.MarketCsDataCreator(
            self,
            description="Create data for content-storage. Child of {}".format(self.id),
            owner=self.owner,
            is_testing=self.Parameters.is_testing,
            check_last_resource=self.Parameters.check_last_resource,
            yt_token=self.Parameters.yt_token,
            yp_token=self.Parameters.yp_token,
            yt_cluster=self.Parameters.yt_cluster,
            vendors_table_path=self.Parameters.vendors_table_path,
            nids_table_path=self.Parameters.nids_table_path,
            hids_table_path=self.Parameters.hids_table_path,
            params_table_path=self.Parameters.params_table_path,
            gumoful_templates_table_path=self.Parameters.gumoful_templates_table_path,
            pers_table_path=self.Parameters.pers_table_path,
            reasons_to_buy_path=self.Parameters.reasons_to_buy_path,
        )

        logging.info('Launch CsDataCreator task')

        creator_task.enqueue()  # Save and enqueue
        self.Context.creator_task_id = creator_task.id
        raise sdk2.WaitTask(
            [creator_task],
            ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
            wait_all=True,
            timeout=self._SUBTASK_WAIT_TIMEOUT_SECONDS,
        )
