import logging
from sandbox import sdk2
from sandbox.common.types import task as ctt
from sandbox.common.types.misc import NotExists
from sandbox.projects.market.content_storage import CsMboDataDownloader

from sandbox.projects.common.ya_deploy import release_integration


class MarketCsMboDataLauncher(release_integration.ReleaseToYaDeployTask2, sdk2.Task):
    _SUBTASK_WAIT_TIMEOUT_SECONDS = 1500
    _release_title = 'Release CsMboDataDownloader'

    class Parameters(CsMboDataDownloader.MarketCsMboDataDownloader.Parameters):
        pass

    def on_execute(self):
        with self.memoize_stage.launch_creator:
            logging.info('Start launcher')
            self._run_creator()

        logging.info('Check CsMboDataDownloader task')

        if self.Context.creator_task_id is not NotExists:
            child = sdk2.Task[self.Context.creator_task_id]
            self.Parameters.task_status = child.Parameters.task_status
            self.Parameters.has_data_prepared = child.Parameters.has_data_prepared
            if child.status == ctt.Status.SUCCESS:
                logging.info('CsMboDataDownloader task status: {}'.format(child.Parameters.task_status))
                if child.Parameters.has_data_prepared:
                    logging.info('Release CsMboDataDownloader task')
                    self.server.release(
                        task_id=self.Context.creator_task_id,
                        type=ctt.ReleaseStatus.STABLE,
                        subject=self._release_title
                    )
                else:
                    logging.info("CsMboDataDownloader task hasn't data prepared")
            else:
                logging.error("CsMboDataDownloader task has been finished with status {}".format(child.status))
        else:
            logging.error("CsMboDataDownloader task id missed")

        logging.info('Launcher has been finised')

    def _run_creator(self):
        logging.info('Init MarketCsMboDataDownloader task')
        subtask = CsMboDataDownloader.MarketCsMboDataDownloader(
            self,
            description="Create data for content-storage. Child of {}".format(self.id),
            owner=self.owner,
            is_testing=self.Parameters.is_testing,
            need_navigation=self.Parameters.need_navigation,
        )

        logging.info('Launch MarketCsMboDataDownloader task')

        subtask.enqueue()  # Save and enqueue
        self.Context.creator_task_id = subtask.id
        raise sdk2.WaitTask(
            [subtask],
            ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
            wait_all=True,
            timeout=self._SUBTASK_WAIT_TIMEOUT_SECONDS,
        )
