# coding=utf-8

import logging
import os.path
import re

from sandbox import sdk2
from sandbox.projects.common.vcs.arc import Arc


class DeleteArcFiles(sdk2.Task):
    """Удаляет файлы из Аркадии."""

    class Parameters(sdk2.Task.Parameters):
        arc_token_vault = sdk2.parameters.Vault("Vault secret contains arc OAuth token",
                                                required=True)
        arc_user = sdk2.parameters.String('Arc username', required=True)
        files_to_delete = sdk2.parameters.List("Список файлов для удаления", required=True)
        commit_message = sdk2.parameters.String("Сообщение коммита", required=True)

        with sdk2.parameters.Output:
            arcadia_pr_id = sdk2.parameters.Integer("Arcadia PR ID", default=0, required=True)

    def on_execute(self):
        arc = Arc(arc_oauth_token=self.Parameters.arc_token_vault.data())
        with arc.mount_path(None, "trunk", fetch_all=False) as mp:
            branch_name = "users/{}/sandboxtask-{}".format(self.Parameters.arc_user, self.id)
            arc.checkout(mp,
                         branch=branch_name,
                         create_branch=True)
            for rel_file_path in self.Parameters.files_to_delete:
                abs_file_path = os.path.join(mp, rel_file_path)
                if not os.path.isfile(abs_file_path):
                    logging.error("Error: %s is not a file.", rel_file_path)
                    raise Exception("ERROR: Path {} is not a file".format(rel_file_path))
                os.remove(abs_file_path)
                logging.info("file %s removed", rel_file_path)
            arc.add(mp, all_changes=True)
            arc.commit(mp, str(self.Parameters.commit_message), all_changes=True)
            arc.push(mp, upstream=branch_name)
            pr = arc.pr_create(mp, message=str(self.Parameters.commit_message), publish=True, auto=True)
            match_id = re.search(r'(?<=a\.yandex\-team\.ru\/review\/)\d+', pr)
            if match_id:
                pr_id = int(match_id.group())
                self.Parameters.arcadia_pr_id = pr_id
                logging.info("PR created: https://a.yandex-team.ru/review/%d", pr_id)
