import io
import zipfile

import jinja2
from sandbox import sdk2
from sandbox.projects.common.build.YaMake2 import YaMake2
from sandbox.projects.common.build.resource_types import ZIPATCH_OUTPUT
from sandbox.sdk2 import parameters


class SchemaConverter(YaMake2):
    class Parameters(YaMake2.Parameters):
        proto_paths = sdk2.parameters.List("Path to proto files", value_type=sdk2.parameters.String)
        proto_java_classes = sdk2.parameters.List("Proto java_package$outer_class", value_type=sdk2.parameters.String)
        runner_path = sdk2.parameters.String("Path to runner", default="market/devexp/exp3_schema_conversion/runner")
        converter_path = sdk2.parameters.String("Path to converter",
                                                default="market/devexp/exp3_schema_conversion/converter")
        jar_name = sdk2.parameters.String("Built jar name", default='exp3_schema_conversion-runner.jar')
        with parameters.Output:
            zipatch_output = parameters.Resource('schemas.json', resource_type=ZIPATCH_OUTPUT)

    def get_targets(self):
        return [str(self.Parameters.runner_path)]

    def gen_ya_make(self, path, template_context):
        with io.open(path + '.jinja2', "r", encoding="utf-8") as file:
            tmpl = file.read()
        with io.open(path, "w", encoding="utf-8") as file:
            tmpl_processed = jinja2.Template(tmpl, keep_trailing_newline=True).render(template_context)
            file.write(tmpl_processed)

    def pre_build(self, source_dir):
        runner_ya_make_path = source_dir + "/" + str(self.Parameters.runner_path) + "/ya.make"
        template_context = {
            "proto_classes": list(self.Parameters.proto_java_classes)
        }
        self.gen_ya_make(runner_ya_make_path, template_context)
        converter_ya_make_path = source_dir + "/" + str(self.Parameters.converter_path) + "/ya.make"
        template_context = {
            "deps": list(self.Parameters.proto_paths)
        }
        self.gen_ya_make(converter_ya_make_path, template_context)
        super(SchemaConverter, self).pre_build(source_dir)

    def post_build(self, source_dir, output_dir, pack_dir):
        self._make_tsum_json_resource(output_dir)
        super(SchemaConverter, self).post_build(source_dir, output_dir, pack_dir)

    def _make_tsum_json_resource(self, output_dir):
        zf = zipfile.ZipFile(output_dir + "/" + self.get_targets()[0] + "/" + str(self.Parameters.jar_name), 'r')

        self.Parameters.zipatch_output = ZIPATCH_OUTPUT(self, description='schemas.json', path='schemas.json',
                                                        share=True)
        app_res = sdk2.ResourceData(self.Parameters.zipatch_output)
        app_res.path.write_bytes(zf.read("schemas.json"))
        app_res.ready()
