# coding=utf-8
import os
from sandbox import sdk2

from sandbox.projects.market.devexp.front.MarketDevexpFrontBuildAbstract import MarketDevexpFrontBuildAbstract


class MARKET_DEVEXP_FRONT_JMF_WEBAPP(sdk2.Resource):
    """MarketDevexp build front jmf-webapp"""
    releasable = True
    releasers = ["MARKET"]


class MarketDevexpFrontBuildJmfWebapp(MarketDevexpFrontBuildAbstract):
    """
    Task build front jmf-webapp
    """

    class Parameters(MarketDevexpFrontBuildAbstract.Parameters):
        with sdk2.parameters.Group("Конфигурация") as app:
            project_name = sdk2.parameters.String("Название проекта (попадет в env при сборке)", required=True)
            cdn_url = sdk2.parameters.String("URL для загрузки статики (попадет в env при сборке)", required=True)

    def _build_project(self, app_path):
        project_name = self.Parameters.project_name
        cdn_url = self.Parameters.cdn_url

        if project_name:
            os.environ["PROJECT_NAME"] = project_name

        if cdn_url:
            os.environ["CDN_URL"] = cdn_url

        super(MarketDevexpFrontBuildJmfWebapp, self)._build_project(app_path)

    @property
    def resource_type(self):
        return MARKET_DEVEXP_FRONT_JMF_WEBAPP
