#!/usr/bin/env bash
set -ex

export NVM_DIR=/opt/nvm
export NODE_VERSIONS="16.9.1 14.17.6 12.16.1"
export NODE_DEFAULT="12.16.1"
export NPM_VERSION="6.14.15"
export GLOBAL_NPM_PACKAGES="yarn veendor@^3.0.4 @yandex-market/carrier@1.2.13 npm-install-peers npm-force-resolutions"

export MAKEDEBPKG_DIR=/opt/makedebpkg

update-ca-certificates

cat > /etc/default/locale <<EOL
LANG=en_US.UTF-8
LANGUAGE=en_US:en
LC_CTYPE="en_US.UTF-8"
LC_NUMERIC="en_US.UTF-8"
LC_TIME="en_US.UTF-8"
LC_COLLATE="en_US.UTF-8"
LC_MONETARY="en_US.UTF-8"
LC_MESSAGES="en_US.UTF-8"
LC_PAPER="en_US.UTF-8"
LC_NAME="en_US.UTF-8"
LC_ADDRESS="en_US.UTF-8"
LC_TELEPHONE="en_US.UTF-8"
LC_MEASUREMENT="en_US.UTF-8"
LC_IDENTIFICATION="en_US.UTF-8"
LC_ALL=en_US.UTF-8

EOL

export LANG=en_US.UTF-8
export LANGUAGE=en_US:en
export LC_ALL=en_US.UTF-8
# locale-gen en_US.UTF-8 && dpkg-reconfigure locales

sudo -u ${USER} apt-get install -y software-properties-common
sudo -u ${USER} add-apt-repository ppa:git-core/ppa
curl -s https://packagecloud.io/install/repositories/github/git-lfs/script.deb.sh | sudo bash
sudo -u ${USER} apt-get update
sudo -u ${USER} apt-get install -y git git-lfs

git clone --depth 1 git://github.yandex-team.ru/market/makedebpkg.git ${MAKEDEBPKG_DIR}

sudo -u ${USER} -H bash -c "export PROFILE=~/.profile && touch ~/.profile && curl -sSL -o- https://raw.githubusercontent.com/creationix/nvm/v0.33.0/install.sh | NVM_DIR=${NVM_DIR} bash"
sudo -u ${USER} -H bash -c "source ~/.profile && for x in ${NODE_VERSIONS}; do nvm install v\$x; done && nvm alias default ${NODE_DEFAULT}"

cat > /etc/profile.d/nvm <<EOL
export NVM_DIR="${NVM_DIR}"
[ -s "\$NVM_DIR/nvm.sh" ] && \. "\$NVM_DIR/nvm.sh"  # This loads nvm
EOL

echo "ALL ALL=(ALL) NOPASSWD: ALL" > /etc/sudoers.d/user

chmod a+r /etc/profile.d/nvm
chmod -R a+rx ${NVM_DIR} ${MAKEDEBPKG_DIR} /root

OLD_PATH="$PATH"

mkdir -p /opt/nodejs
for v in ${NODE_VERSIONS}; do
    major=$(echo $v | sed 's/\..*//')
    ln -fsT ${NVM_DIR}/versions/node/v${v} /opt/nodejs/${major}
    export PATH="/opt/nodejs/${major}/bin:${OLD_PATH}"

    npm install -g npm@${NPM_VERSION}
    npm install -g --registry="http://npm.yandex-team.ru" ${GLOBAL_NPM_PACKAGES}
done
