# coding=utf-8
import subprocess

from sandbox import sdk2
import sandbox.sdk2.path as spath
from sandbox.projects.market.devexp.front.MarketDevexpFrontBuildAbstract import MarketDevexpFrontBuildAbstract


class MARKET_DEVEXP_FRONT_OPERATOR_WINDOW(sdk2.Resource):
    """MarketDevexp build front planner"""
    releasable = True
    releasers = ["MARKET"]


class MarketDevexpFrontBuildOperatorWindow(MarketDevexpFrontBuildAbstract):
    """
    Task build front Planner
    """

    def _process_task(self, app_path):
        self._build_project(app_path)
        pack_dist_archive_path = self._create_tar(app_path)
        self._app_create_resource(pack_dist_archive_path, app_path)

    def _app_create_resource(self, pack_dist_archive_path, app_path):
        rev_parse = subprocess.Popen(
            ["arc", "rev-parse", "HEAD"],
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
            cwd=app_path,
        )
        (commit, err) = rev_parse.communicate()
        commit = commit.strip()
        res = sdk2.ResourceData(self.resource_type(
            self, "Resource", "operator-window."+commit+".tar.gz"
        ))
        if res.path.exists():
            res.path.unlink()
        res.path.write_bytes(spath.Path(pack_dist_archive_path).read_bytes())
        res.ready()

    @property
    def resource_type(self):
        return MARKET_DEVEXP_FRONT_OPERATOR_WINDOW
