# coding=utf-8

import os

from sandbox import sdk2
from sandbox.common.types import misc as ctm
from sandbox.projects.market.devexp.front.helpers.SetEnv import SetEnv
from sandbox.projects.market.devexp.front.helpers.sandbox_helpers import rich_check_call
from sandbox.projects.market.devexp.front.helpers.node import create_node_selector
from sandbox.projects.market.devexp.front.helpers.ubuntu import create_ubuntu_selector, setup_container
from sandbox.projects.common.arcadia import sdk as arcadia_sdk

DISK_SPACE = 3 * 1024  # 3 Gb


class MarketDevexpFrontCI(sdk2.Task):
    """
    Таска для запуска CI проверок фронта marketdevexp
    """

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64
        disk_space = DISK_SPACE

    class Parameters(sdk2.Task.Parameters):
        ubuntu_version = create_ubuntu_selector()
        nodejs_version = create_node_selector()

        arcadia_url = sdk2.parameters.ArcadiaUrl(
            "Arcadia repository url",
            default_value="arcadia-arc:/#trunk",
            required=True
        )
        app_dir = sdk2.parameters.String(
            "App dir",
            default="market/infra/market-planner/webapp",
            required=True
        )
        command = sdk2.parameters.String(
            "Команда для запуска",
            description="Например, npm install && npm run lint:eslint",
            required=True
        )

    def on_enqueue(self):
        super(MarketDevexpFrontCI, self).on_enqueue()
        setup_container(self)

    def _test(self, app_path):
        rich_check_call(["bash", "-c", self.Parameters.command], self, "test", cwd=app_path)

    def on_execute(self):
        super(MarketDevexpFrontCI, self).on_execute()
        with SetEnv(self, nodejs_version=self.Parameters.nodejs_version, arc_token_vault="robot-market-devexp-arc-token"):
            self._prepare_repos()

    def _prepare_repos(self):
        url = self.Parameters.arcadia_url
        use_arc = True
        with arcadia_sdk.mount_arc_path(url, use_arc_instead_of_aapi=use_arc) as arcadia_root:
            arcadia_app_path = os.path.join(arcadia_root, self.Parameters.app_dir)
            self._test(arcadia_app_path)
