import logging
import os
import shutil

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

import node

ROBOT_NAME = "robot-market-devexp"
GIT_USERNAME = "Robot Market Devexp"
GIT_EMAIL = "robot-market-devexp@yandex-team.ru"
NODE_EXTRA_CA_CERTS = "/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt"
ST_OAUTH_TOKEN_VAULT_KEY = "robot-market-devexp-st-token"


class SetEnv(object):
    def __init__(
        self,
        task,
        nodejs_version=node.NODE_DEFAULT,
        arc_token_vault=None,
        git_config=True
    ):
        logging.error("ENV __INIT__")
        super(SetEnv, self).__init__()

        self.task = task
        self.nodejs_version = nodejs_version
        self.arc_token_vault = arc_token_vault
        self.git_config = git_config

        self.__env_backup = {}

    def __enter__(self):
        self.__env_backup = os.environ.copy()

        os.environ["NODE_EXTRA_CA_CERTS"] = NODE_EXTRA_CA_CERTS

        if self.nodejs_version:
            node_path = node.get_node_path(self.nodejs_version)
            os.environ["PATH"] = "{}:{}".format(node_path, os.environ["PATH"])

        if self.arc_token_vault:
            os.environ["ARC_TOKEN"] = sdk2.Vault.data(self.arc_token_vault)

        if self.git_config:
            if os.path.isfile(os.path.expanduser("~/.gitconfig")):
                shutil.copyfile(
                    os.path.expanduser("~/.gitconfig"),
                    os.path.expanduser("~/.gitconfig.bak"),
                )

            sp.check_call(["git", "config", "--global", "user.name", GIT_USERNAME])
            sp.check_call(["git", "config", "--global", "user.email", GIT_EMAIL])

    def __exit__(self, exc_type, exc_val, exc_tb):
        os.environ.clear()
        os.environ.update(self.__env_backup)
