# coding=utf-8

from sandbox import sdk2


NODE_TWELVE = "12"
NODE_FOURTEEN = "14"
NODE_SIXTEEN = "16"
NODE_VERSIONS = (NODE_TWELVE, NODE_FOURTEEN, NODE_SIXTEEN)
NODE_DEFAULT = NODE_TWELVE


def get_node_path(node_version):
    """
    Возвращает путь до bin папки для ноды node_version.
    :param node_version:
    :return:
    """

    if node_version == NODE_TWELVE:
        return "/opt/nodejs/12/bin"
    elif node_version == NODE_FOURTEEN:
        return "/opt/nodejs/14/bin"
    elif node_version == NODE_SIXTEEN:
        return "/opt/nodejs/16/bin"
    else:
        raise Exception("Unsupported version {}".format(node_version))


def create_node_selector(default_node_version=NODE_DEFAULT):
    with sdk2.parameters.String("Версия Node.js для сборки", required=True, multiline=True) as node_version:
        for version in NODE_VERSIONS:
            is_default = version == default_node_version
            node_version.values[version] = node_version.Value(version, default=is_default)

    return node_version
