# -*- coding: utf-8 -*-
import re
from sandbox import sdk2
from sandbox.projects.market.devexp.front.helpers.SetEnv import ST_OAUTH_TOKEN_VAULT_KEY, ROBOT_NAME


class FixVersion(sdk2.parameters.String):
    @classmethod
    def cast(cls, value):
        value = super(FixVersion, cls).cast(value)
        if value is None or not value and not cls.required:
            return value

        if re.match("^\d{4}\.\d+(?:\.\d+)?[md]?$", value) is None:  # noqa
            raise ValueError("Fix version must be in format `YYYY.R.PS`")
        return value


class ReleaseTicket(sdk2.parameters.String):
    @classmethod
    def cast(cls, value):
        value = super(ReleaseTicket, cls).cast(value)
        if not cls.required and not value:
            return value

        msg = "Release ticket must be in format `QUEUENAME-ID`"
        assert re.match("^[A-Z]+-\d+$", value) is not None, msg  # noqa
        return value


def colored_text(color, text):
    return '!!({color}){text}!!'.format(color=color, text=text)


def link_text(ref, text):
    return '(({ref} {text}))'.format(ref=ref, text=text)


def cut_text(cut_header, hidden_text):
    return '<{{{cut_header}\n%%{hidden_text}%%}}>'.format(cut_header=cut_header, hidden_text=hidden_text)


def hidden_id(value):
    return '<# <div id="{id}"/> #>'.format(id=value)


def send_startrek_report(message, ticket_id):
    oauth_token = sdk2.Vault.data(ST_OAUTH_TOKEN_VAULT_KEY)

    from startrek_client import Startrek
    st = Startrek(useragent=ROBOT_NAME, token=oauth_token)
    issue = st.issues[ticket_id]
    issue.comments.create(text=message)
