# coding=utf-8

from sandbox.projects.common.vcs.arc import Arc, ResetMode


class MarketArcVcs(object):
    arc = None
    mount_point = None
    arcadia = None

    def arc_mount(self, store_path=None, object_store_path=None, arc_token=None):
        self.arc = Arc(arc_oauth_token=arc_token)
        self.mount_point = self.arc.mount_path(None, "trunk", fetch_all=False, store_path=store_path, object_store_path=object_store_path)
        self.arcadia = self.mount_point.__enter__()

    def arc_unmount(self):
        if self.mount_point and self.mount_point.mounted:
            self.mount_point.unmount()
            self.mount_point = None

    def arc_status(self, as_dict=False):
        return self.arc.status(self.arcadia, as_dict=as_dict)

    def arc_branch(self, branch=None, remote_branch=None, all=False, as_dict=False):
        return self.arc.branch(self.arcadia, branch=branch, remote_branch=remote_branch, all=all, as_dict=as_dict)

    def arc_fetch(self, branch=None):
        return self.arc.fetch(self.arcadia, branch=branch)

    def arc_pull(self, rebase=False):
        return self.arc.pull(self.arcadia, rebase=rebase)

    def arc_reset(self, mode=ResetMode.MIXED, branch=None, path=None, force=False):
        self.arc.reset(self.arcadia, mode, branch, path, force)

    def arc_checkout(self, branch="trunk", create_branch=False, start_point=None, track=False, force=False):
        return self.arc.checkout(
            self.arcadia,
            branch=branch,
            create_branch=create_branch,
            start_point=start_point,
            track=track,
            force=force
        )

    def arc_cherry_pick(self, commit=None, add_commit_name=False, allow_empty=False):
        return self.arc.cherry_pick(
            self.arcadia,
            commit=commit,
            add_commit_name=add_commit_name,
            allow_empty=allow_empty
        )

    def arc_commit(self, message, all_changes=False):
        return self.arc.commit(self.arcadia, message=message, all_changes=all_changes)

    def arc_push(self, upstream=None, force=False, refspecs=None):
        return self.arc.push(
            self.arcadia,
            upstream=upstream,
            force=force,
            refspecs=refspecs
        )

    def arc_log(
        self,
        path=None,
        start_commit=None,
        end_commit=None,
        max_count=0,
        author="",
        as_dict=False,
        walk=True,
        name_only=False,
    ):
        return self.arc.log(
            self.arcadia,
            path=path,
            start_commit=start_commit,
            end_commit=end_commit,
            max_count=max_count,
            author=author,
            as_dict=as_dict,
            walk=walk,
            name_only=name_only
        )
