# -*- coding: utf-8 -*-
import logging
import datetime
import requests

from sandbox import sdk2
from sandbox.projects.common.binary_task import deprecated as binary_task
import sandbox.common.types.task as ctt

CUSTOM_ENVIRONMENT = "custom"

class MarketCreateFilterDataLink(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """Create link for filter data
    """

    class Parameters(sdk2.Task.Parameters):
        oauth_token = sdk2.parameters.Vault("Vault secret contains OAuth token; should provide access to YT", required=True)
        ext_params = binary_task.binary_release_parameters(stable=True)

        with sdk2.parameters.RadioGroup("Environment for task") as environment:
            environment.values.custom = environment.Value(CUSTOM_ENVIRONMENT, default=True)
            environment.values.testing = environment.Value("testing")
            environment.values.production = environment.Value("production")
        with sdk2.parameters.Group('Build type parameters') as build_type_parameters:
            build_type = sdk2.parameters.String("Build type", required=True, default=ctt.ReleaseStatus.STABLE)
        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            cluster = sdk2.parameters.String("YT cluster", required=True, default="hahn")
            with environment.value[CUSTOM_ENVIRONMENT]:
                dir_for_link = sdk2.parameters.String("dir for link in YT", required=True)
                exported_table = sdk2.parameters.String("exported to axa table in YT", required=True)

        with sdk2.parameters.Group('STEP parameters') as step_parameters:
            event_params = sdk2.parameters.Dict("Params from STEP event, overrides all")

    def on_execute(self):
        from market.dynamic_pricing.deprectated.create_link.lib import create_link

        create_link.create_link(
            yt_token=self.Parameters.oauth_token.data(),
            cluster=self.cluster,
            dir_for_link=self.dir_for_link,
			exported_table=self.exported_table
        )


    @property
    def environment(self):
        return self.Parameters.event_params.get('environment', self.Parameters.environment)

    @property
    def base_yt_dir(self):
        return '//home/market/{env}/monetize/dynamic_pricing'.format(env=self.environment)

    @property
    def build_type(self):
        return self.Parameters.event_params.get('build_type', self.Parameters.build_type)

    @property
    def cluster(self):
        return self.Parameters.event_params.get('cluster', self.Parameters.cluster)

    @property
    def dir_for_link(self):
		if self.environment == CUSTOM_ENVIRONMENT:
			return self.Parameters.dir_for_link
		else:
			return self.base_yt_dir + '/filter_data_for_axapta'

    @property
    def exported_table(self):
        return self.Parameters.event_params.get('path', self.Parameters.exported_table)
