import logging
import json


class MarketAccessClient:
    def __init__(
            self,
            host,
            log=None,
            *args,
            **kwargs
    ):
        self.host = host
        self.log = log or logging.getLogger('market_access_client')
        self.log.debug('Market-Access: %s', 'Created')

    def get_tvm_ticket(self, self_tvm_id, self_tvm_secret, dst_tvm_id):
        from tvmauth import TvmClient, TvmApiClientSettings

        c = TvmClient(
            TvmApiClientSettings(
                self_tvm_id=self_tvm_id,
                self_secret=self_tvm_secret,
                dsts=[dst_tvm_id],
                )
            )
        return c.get_service_ticket_for(tvm_id=dst_tvm_id)

    def create_version(self, resource_name, rbtorrent, tvm_ticket):
        import requests
        path = self.host + '/v1/resources/{resource_name}/versions'.format(resource_name=resource_name)
        self.log.info('Using {path}'.format(path=path))

        body = {
            "change": [0],
            "resource_name": resource_name,
            "storage": [{
                "location": {
                    "access": {
                    "rbtorrent": rbtorrent
                        }
                    }
                }]
            }
        body = json.dumps(body)
        self.log.info(body)
        r = requests.post(
            path,
            headers={
                'Content-Type': 'application/json',
                'X-Ya-Service-Ticket': tvm_ticket,
            },
            data=body
            )
        self.log.info(r.text)
