import logging
from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment

SECRET = "sec-01fpt49nyy3vqe34yc513c2tt3"


class MarketRegionalPricingUpdateResource(sdk2.Resource):
    releasers = ["lsiraziev"]
    releasable = True
    share = True  # (create rbtorrent) resource
    test_attr = sdk2.Attributes.Integer("Some test attribute")


class MarketRegionalPricingUpdateTask(sdk2.Task):

    def yt_table_to_proto(self, table_in):
        import yt.wrapper as yt
        from market.dynamic_pricing.pricing.regional_pricing.proto.regional_pricing_pb2 import RegionalPricingToDatasourceIdMap

        yt.config.set_proxy('hahn')

        proto = RegionalPricingToDatasourceIdMap()
        for row in yt.read_table(table_in):
            item = proto.the_map.add()
            item.msku = row["market_sku"]
            item.ssku = row["shop_sku"]
            item.price = row["new_price"]
            item.region_id = row["region_id"]

        target_path = yt.cypress_commands.get_attribute(table_in + '&', "target_path", None)
        if target_path is not None:
            proto.table_name = target_path.split('/')[-1]

        return proto.SerializeToString()

    class Parameters(sdk2.Parameters):
        production = sdk2.parameters.Bool("Use production tables and endpoins", default=False)

    class Requirements(sdk2.Task.Requirements):
        environments = [
            PipEnvironment('yandex-yt'),
            PipEnvironment('requests'),
        ]

    def on_execute(self):
        import yt.wrapper as yt
        production = self.Parameters.production
        token_yt = sdk2.yav.Secret(SECRET).data()["token-yt"]
        yt.config["proxy"]["url"] = "hahn"
        yt.config["token"] = token_yt

        text_for_market_access = self.yt_table_to_proto('//home/market/testing/monetize/dynamic_pricing/regional_prices/2022-02-07')
        rbtorrent = self.create_sandbox_text_file_resource(text_for_market_access)
        self.update_file_in_market_access(rbtorrent, production)

    def create_sandbox_text_file_resource(self, text):
        resource = MarketRegionalPricingUpdateResource(self, "Market regional pricing resource", "market_regional_pricing.bin")
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.write_bytes(text)
        resource_data.ready()
        logging.info(resource)
        rbtorrent = resource.skynet_id
        logging.info("Sandbox resource creating successful: " + rbtorrent)
        return rbtorrent

    def update_file_in_market_access(self, rbtorrent, production):
        from .MarketAccessClient import MarketAccessClient

        resource_name = "market_regional_pricing"

        secret = sdk2.yav.Secret(SECRET).data()

        if production:
            self_tvm_id = int(secret["self_tvm_id"])
            self_tvm_secret = secret["self_tvm_secret"]
            dst_tvm_id = int(secret["dst_tvm_id"])
            access_client = MarketAccessClient('https://access.vs.market.yandex.net', logging)
            tvm_ticket = access_client.get_tvm_ticket(self_tvm_id, self_tvm_secret, dst_tvm_id)
        else:
            access_client = MarketAccessClient('https://access.tst.vs.market.yandex.net', logging)
            tvm_ticket = secret['tvm_ticket']

        access_client.create_version(resource_name, rbtorrent, tvm_ticket)
        logging.info("Update file in market access is successful")
