# coding=utf-8

import logging
import re
from sandbox import sdk2
from sandbox.sandboxsdk import environments


class DocTicketAutoCreator(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_token_vault_key = sdk2.parameters.String('Startrack token vault key', required=True)
        st_url = sdk2.parameters.String('Startrack url', required=True)
        st_queue = sdk2.parameters.String('Startrack queue', required=True)
        ffwf_database_user_vault_key = sdk2.parameters.String('FFWF databse user vault key',
                                                              required=True)
        ffwf_database_password_vault_key = sdk2.parameters.String('FFWF databse password vault key',
                                                                  required=True)
        find_by_last_days = sdk2.parameters.Integer('Find request by last N days', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('psycopg2-binary'),
                        environments.PipEnvironment('yandex_tracker_client', version="1.3",
                                                    custom_parameters=["--upgrade-strategy only-if-needed"]),
                        environments.PipEnvironment('startrek_client', version="2.3.0",
                                                    custom_parameters=["--upgrade-strategy only-if-needed"]))

    class Request:
        def __init__(self, service_request_id, service_name, real_supplier_name, is_xdoc, external_request_id):
            self.service_request_id = service_request_id
            self.service_name = service_name
            self.real_supplier_name = real_supplier_name
            self.is_xdoc = is_xdoc
            self.external_request_id = external_request_id

    def create_task_in_startrack(self, requests):
        from startrek_client import Startrek
        st = Startrek(useragent=self.Parameters.st_user_agent,
                      base_url=self.Parameters.st_url,
                      token=sdk2.Vault.data(self.Parameters.st_token_vault_key))

        logging.debug('Length of requests = ' + str(len(requests)))

        for row in requests:

            service_tag = '1Р-поставка ' + str(row.service_name)
            summary = str(row.service_request_id) + ' ' + str(row.real_supplier_name)
            problem = str('=====Номер поставки \n' +
                          str(row.service_request_id) + ' \n' +
                          '=====Поставщик \n' +
                          str(row.real_supplier_name)+ ' \n' +
                          '=====Склад \n' +
                          service_tag + ' \n' +
                          '=====Номер ЗП ' + ' \n' +
                          str(row.external_request_id))

            tag = row.service_request_id

            issues_opened = st.issues.find('Queue: ' + str(self.Parameters.st_queue) +
                                           ' Tags: "' + tag + '"' +
                                           ' "Sort By": Key DESC',
                                           per_page=1)

            tags=[tag, service_tag]
            if (bool(row.is_xdoc)):
                tags.append('X-Dock')

            if not issues_opened :
                externalId = self.try_get_external_id(str(row.external_request_id))
                if externalId is not None:
                    st.issues.create(
                        queue=str(self.Parameters.st_queue),
                        summary=summary,
                        type={'name': 'Задача'},
                        description=problem,
                        tags=tags,
                        deliveryNumber=str(row.service_request_id),
                        merchant=str(row.real_supplier_name),
                        poNumber=externalId)
                else:
                    st.issues.create(
                        queue=str(self.Parameters.st_queue),
                        summary=summary,
                        type={'name': 'Задача'},
                        description=problem,
                        tags=tags,
                        deliveryNumber=str(row.service_request_id),
                        merchant=str(row.real_supplier_name))
                logging.debug('Task created for ' + str(row.service_request_id))
            else :
                logging.debug('Task have already created for ' + issues_opened[0].summary)

    def geFfwfRequests(self) :
        requests = []
        conn = None
        cur = None
        try:
            user = sdk2.Vault.data(self.Parameters.ffwf_database_user_vault_key)
            password = sdk2.Vault.data(self.Parameters.ffwf_database_password_vault_key)
            logging.info('Connecting to the FFWF database...')
            import psycopg2
            conn = psycopg2.connect(
                host="market-ff-workflow01f.db.yandex.net",
                port="6432",
                database="market_ff_workflow",
                user=user,
                password=password)
            logging.info('Connected')

            cur = conn.cursor()

            cur.execute("select sr.service_request_id, "
                        "       fs.name as service_name, "
                        "       (select ri.real_supplier_name "
                        "        from request_item ri "
                        "        where ri.request_id = sr.id "
                        "          and ri.real_supplier_name is not null "
                        "        limit 1), "
                        "       case when sr.x_doc_service_id is not null then true else false end as is_xdoc, "
                        "       sr.external_request_id "
                        "from shop_request sr "
                        "         left join fulfillment_service fs on sr.service_id = fs.id "
                        "         left join supplier s on sr.supplier_id = s.id "
                        "where sr.type = 0 "
                        "  and exists(select * from request_status_history rsh "
                        "             where rsh.request_id = sr.id "
                        "               and rsh.status in (9, 6, 7, 10)) "
                        "  and sr.created_at > now() - interval '" + str(self.Parameters.find_by_last_days) + " day' "
                        "  and s.type = 1")

            raw_result = cur.fetchall()

            for row in raw_result:
                requests.append(self.Request(row[0], row[1], row[2], row[3], row[4]))

            cur.close()
            conn.close()

        except Exception as error:
            logging.info(error)
        finally:
            if cur is not None:
                cur.close()
            if conn is not None:
                conn.close()
            logging.info('FFWF database connection closed.')

        return requests

    def try_get_external_id(self, str) :
        try:
            if len(str) > 0:
                return int(re.sub(r"\D", "", str))
            else :
                return None
        except ValueError:
            return None

    def on_execute(self):
        requests = self.geFfwfRequests()
        self.create_task_in_startrack(requests)
