# coding=utf-8

import logging
from datetime import datetime, timedelta

from sandbox import sdk2
from sandbox.common.telegram import TelegramBot
from sandbox.sandboxsdk import environments


class DutyBugsReminder(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        telegram_bot_token_vault_key = sdk2.parameters.String('Telegram bot token key', required=True)
        telegram_chat_id = sdk2.parameters.String('Telegram chat id', required=True)
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_url = sdk2.parameters.String('Startrack url', required=True)
        st_token_vault_key = sdk2.parameters.String('Startrack token vault key', required=True)
        st_queue = sdk2.parameters.String('Startrack queue', required=True)
        st_task_type = sdk2.parameters.String('Startrack task type', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('psycopg2-binary'),
                        environments.PipEnvironment('yandex_tracker_client', version="1.3", custom_parameters=["--upgrade-strategy only-if-needed"]),
                        environments.PipEnvironment('startrek_client', version="2.3.0", custom_parameters=["--upgrade-strategy only-if-needed"]))

    def find_bug_tickets(self):
        from startrek_client import Startrek
        st = Startrek(useragent=self.Parameters.st_user_agent,
                      base_url=self.Parameters.st_url,
                      token=sdk2.Vault.data(self.Parameters.st_token_vault_key))

        return st.issues.find('Queue: ' + str(self.Parameters.st_queue) +
                                ' Type: Ошибка' +
                                ' "Стенд": "Production", empty()' +
                                ' ZBP: !"Нет"' +
                                ' Created: >= 1.04.2021' +
                                ' AND Resolution:empty()' +
                                ' "Sort By": Key DESC',
                                per_page=1000
                                )

    def create_message(self, issues):
        if issues is None or len(issues) == 0:
            return 'Не найдено багов прода. Спасибо дежурному за отличную работу!'
        message = 'Найдено ' + str(len(issues)) + ' багов прода, просьба дежурного посмотреть во втором приоритете после алертов, если сейчас не выходной день:\n'
        for issue in issues:
            message = message + 'Описание: ' + str(issue.summary) + '\n'
            message = message + 'Статус: ' + str(issue.status.name) + '\n'
            message = message + 'Приоритет: ' + str(issue.priority.name) + '\n'
            message = message + 'Исполнитель: ' + self.get_assignee(issue) + '\n'
            message = message + 'Тикет: https://st.yandex-team.ru/' + str(issue.key) + '\n\n'
        return message

    def get_assignee(self, issue):
        if issue.assignee:
            return str(issue.assignee.firstName) + ' ' + str(issue.assignee.lastName)
        return 'Не назначен'

    def send_message(self, message):
        bot = TelegramBot(bot_token=sdk2.Vault.data(self.Parameters.telegram_bot_token_vault_key))
        bot.send_message(self.Parameters.telegram_chat_id, message)

    def on_execute(self):
        issues = self.find_bug_tickets()
        message = self.create_message(issues)
        self.send_message(message)
