# coding=utf-8
from sandbox import sdk2
from sandbox.sandboxsdk import environments


class GenerateAuctionCurls(sdk2.Task):
    vendorName = "Vendor"
    sku = "SKU"
    uits = "UIT"

    class Parameters(sdk2.Task.Parameters):
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_token_vault_key = sdk2.parameters.String('Startrack token vault key', required=True)
        st_ticket = sdk2.parameters.String('Startrack ticket name', required=True)
        st_filename = sdk2.parameters.String('Startrack file name', required=True)
        st_cte_url = sdk2.parameters.String('CTE url (/ in the end)', required=True)
        st_ffwf_url = sdk2.parameters.String('FFWF url (/ in the end)', required=True)
        st_vendor_column = sdk2.parameters.Integer('Vendor column from 0', required=True)
        st_sku_column = sdk2.parameters.Integer('Sku column from 0', required=True)
        st_uits_column = sdk2.parameters.Integer('Uits column from 0', required=True)
        st_auction_value = sdk2.parameters.String('Auction value', required=True)
        st_warehouse_value = sdk2.parameters.Integer('Warehouse value', required=True)
        st_shift_from_up = sdk2.parameters.Integer('Shift from upper border', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('xlrd'),
                        environments.PipEnvironment('yandex_tracker_client', version="1.3",
                                                    custom_parameters=["--upgrade-strategy only-if-needed"]),
                        environments.PipEnvironment('startrek_client', version="2.3.0",
                                                    custom_parameters=["--upgrade-strategy only-if-needed"]))

    def loadDataFromExcel(self, fileName):
        import xlrd
        book = xlrd.open_workbook("./" + fileName)
        sheet = book.sheet_by_index(0)
        values = []
        for row in range(int(self.Parameters.st_shift_from_up), sheet.nrows):
            rowMap = dict()
            for col in range(0, sheet.ncols):
                if col == int(self.Parameters.st_vendor_column):
                    rowMap['Vendor'] = str(int(sheet[row][col].value))
                if col == int(self.Parameters.st_sku_column):
                    rowMap['SKU'] = sheet[row][col].value
                if col == int(self.Parameters.st_uits_column):
                    uit = str(sheet[row][col].value)
                    if uit.endswith(".0"):
                        uit = uit[:-2]
                    rowMap['UIT'] = uit
            rowMap['auction'] = str(self.Parameters.st_auction_value)
            rowMap['Warehouse'] = str(self.Parameters.st_warehouse_value)
            values.append(rowMap)
        s = set()
        for x in values:
            s.add((x['Vendor'], x['SKU']))
        result = []
        for x in s:
            put = dict()
            put['Vendor'] = x[0]
            put['SKU'] = x[1]
            put['UIT'] = []
            put['auction'] = str(self.Parameters.st_auction_value)
            put['Warehouse'] = str(self.Parameters.st_warehouse_value)
            for y in values:
                if y['Vendor'] == x[0] and y['SKU'] == x[1]:
                    put['UIT'].append(y['UIT'])
            result.append(put)
        return result

    def writeComment(self, text, issue):
        issue.comments.create(text=text)

    def createCurls(self):
        import os
        from startrek_client import Startrek
        client = Startrek(useragent=self.Parameters.st_user_agent,
                          token=sdk2.Vault.data(self.Parameters.st_token_vault_key))
        ticket = self.Parameters.st_ticket
        filename = str(self.Parameters.st_filename)
        issue = client.issues[ticket]
        attachments = issue.attachments
        file = None
        for x in attachments:
            if x.name == filename:
                file = x
        if file is None:
            raise Exception("File not found")
        file.download_to('./')
        values = self.loadDataFromExcel(filename)
        os.remove("./" + filename)
        job = Generator(str(self.Parameters.st_cte_url), str(self.Parameters.st_ffwf_url))
        cteCreateAuctionComment = job.cteCreateAuction(values)
        cteUnfreezeComment = job.unfreezeCteCurl(values)
        ffwfLoadShadowWithdrawComment = job.ffwfLoadShadowWithdraw(values)
        commonComment = 'Создать аукцион в ЦТЭ:\n' + cteCreateAuctionComment + \
                        '\n\nЕсли аукцион завершился неудачно, то отменить аукцион в ЦТЭ:\n' + cteUnfreezeComment + \
                        '\n\nЕсли аукцион завершился удачно, то создать изъятие:\n' + ffwfLoadShadowWithdrawComment
        self.writeComment(commonComment, issue)

    def on_execute(self):
        self.createCurls()


class Generator:
    vendorName = "Vendor"
    sku = "SKU"
    uits = "UIT"
    auctionId = "auction"
    warehouse = "Warehouse"

    def __init__(self, cteUrl, ffwfUrl):
        self.cteUrl = cteUrl
        self.ffwfUrl = ffwfUrl

    def generateCurlWithJson(self, url, jsonStr, method):
        return "%%curl --header \"Content-Type: application/json\" \\\n" \
               + " --request " + method + " \\\n" + \
               " --data \'" + jsonStr + "\' \\\n" + \
               '"' + url + '"' + "%%"

    def generateCurlWithoutJson(self, url, method):
        return "%%curl \\\n" \
               + " --request " + method + " \\\n" + \
               '"' + url + '"' + "%%"

    # Генерация для cte
    def cteBookItem(self, values):
        self.generateCurlWithJson(self.cteUrl, self.cteCreateAuctionJson(values), "POST")

    def cteCreateAuctionItem(self, values):
        return {"vendorId": values[self.vendorName], "sku": values[self.sku], "uits": values[self.uits]}

    def cteCreateAuctionJson(self, values):
        import json
        return str(json.dumps({"items": [self.cteCreateAuctionItem(x) for x in values]}))

    def unfreezeCteCurl(self, values):
        return self.generateCurlWithoutJson(self.cteUrl + "auction/cancel-auction/" + values[0][self.auctionId], "PUT")

    def cteCreateAuction(self, values):
        return self.generateCurlWithJson(
            self.cteUrl + "auction/create-auction/" + values[0][self.warehouse] + "/" + values[0][self.auctionId],
            self.cteCreateAuctionJson(values), 'POST')

    # Генерация для ffwf
    def ffwfGenerateCounts(self, values):
        return [{"countType": "FIT", "quantity": len(values[self.uits]),
                 "unitIds": [{"partialIds": [{"idType": "UIT", "value": x} for x in values[self.uits]]}]}]

    def ffwfGenerateCompositeId(self, values):
        return {"partialIds": [{"idType": "ARTICLE", "value": values[self.sku]},
                               {"idType": "VENDOR_ID", "value": values[self.vendorName]}]}

    def ffwfGenerateUnitInfo(self, values):
        return {"counts": self.ffwfGenerateCounts(values), "compositeId": self.ffwfGenerateCompositeId(values)}

    def ffwfGenerateItem(self, values):
        return {"unitInfo": self.ffwfGenerateUnitInfo(values)}

    def ffwfGenerateItems(self, values):
        return [self.ffwfGenerateItem(x) for x in values]

    def ffwfGenerateOutboundRegistry(self, values):
        from datetime import datetime
        time = datetime.now().strftime("%Y-%m-%dT%H:%M:%S+03:00")
        return {"registryType": 0, "date": time,
                "items": self.ffwfGenerateItems(values)}

    def ffwfLoadShadowWithdraw(self, values):
        from datetime import datetime, timedelta
        import json
        time = (datetime.now() + timedelta(days = 3)).strftime("%Y-%m-%dT%H:%M:%S+03:00")
        data = {"outboundHeader": {"date": time, "type": 1003},
                "outboundRegistry": {"outboundRegistry": self.ffwfGenerateOutboundRegistry(values)},
                "auctionId": values[0][self.auctionId],
                "serviceId": values[0][self.warehouse]}
        return self.generateCurlWithJson(self.ffwfUrl + "withdraws-with-registry", str(json.dumps(data)), "POST")
