# coding=utf-8

import logging

import sandbox.common.types.misc as ctm
from sandbox import sdk2
from sandbox.common.telegram import TelegramBot
from sandbox.sandboxsdk import environments


class IncorrectlyFreezedOutboundsChecker(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ss_database_user_vault_key = sdk2.parameters.String('SS databse user vault key', required=True)
        ss_database_password_vault_key = sdk2.parameters.String('SS databse password vault key',
                                                                              required=True)
        ffwf_database_user_vault_key = sdk2.parameters.String('FFWF databse user vault key',
                                                                            required=True)
        ffwf_database_password_vault_key = sdk2.parameters.String('FFWF databse password vault key',
                                                                                required=True)
        telegram_bot_token_vault_key = sdk2.parameters.String('Telegram bot token key', required=True)
        telegram_chat_id = sdk2.parameters.String('Telegram chat id', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('psycopg2-binary'),)
        dns = ctm.DnsType.DNS64

    def ssFreezedOutbounds(self):
        conn = None
        cur = None
        try:
            user = sdk2.Vault.data(self.Parameters.ss_database_user_vault_key)
            password = sdk2.Vault.data(self.Parameters.ss_database_password_vault_key)
            logging.info('Connecting to the SS database...')
            import psycopg2
            conn = psycopg2.connect(
                host="vla-ztlnd24dqcjd0m75.db.yandex.net",
                port="6432",
                database="market_stockdb",
                user=user,
                password=password)
            logging.info('Connected')

            cur = conn.cursor()
            logging.info('Getting unfreezed orders...')
            cur.execute("select distinct sf.reason_id from stock_freeze sf "
                        "left join unfreeze_job uj on sf.id = uj.stock_freeze_id "
                        "where uj.id is null and sf.deleted = false and sf.reason_type = 'OUTBOUND'")

            raw_result = cur.fetchall()
            result = []
            for row in raw_result:
                result.append(str(row[0]))
            return result
        except Exception as error:
            logging.info(error)
        finally:
            if cur is not None:
                cur.close()
            if conn is not None:
                conn.close()
            logging.info('SS database connection closed.')

    def checkIncorrectlyFreezed(self, freezedOutbounds):
        conn = None
        cur = None
        try:
            freezedOutboundsString = "'" + "', '".join(set(freezedOutbounds)) + "'"
            user = sdk2.Vault.data(self.Parameters.ffwf_database_user_vault_key)
            password = sdk2.Vault.data(self.Parameters.ffwf_database_password_vault_key)
            logging.info('Connecting to the FFWF database...')
            import psycopg2
            conn = psycopg2.connect(
                host="market-ff-workflow01f.db.yandex.net",
                port="6432",
                database="market_ff_workflow",
                user=user,
                password=password)
            logging.info('Connected')

            cur = conn.cursor()

            cur.execute("select id, status from shop_request "
                        "where type in (1, 17) and (id in (" + freezedOutboundsString + ") or parent_request_id in (" + freezedOutboundsString + "))" +
                        "and status in (4, 5, 8, 10) and updated_at < now() - interval '1 hour'")
            raw_result = cur.fetchall()

            incorrectlyFreezedByStatus = {}
            for row in raw_result:
                ffwf_id = row[0]
                status = row[1]
                if not incorrectlyFreezedByStatus.__contains__(status):
                    incorrectlyFreezedByStatus[status] = []
                incorrectlyFreezedByStatus[status].append(str(ffwf_id))

            cur.close()

            cur = conn.cursor()

            cur.execute("select id, status from shop_request "
                        "where type = 18 and id in (" + freezedOutboundsString + ")"
                        "and status = 8 and updated_at < now() - interval '4 hours'")
            raw_result = cur.fetchall()

            for row in raw_result:
                ffwf_id = row[0]
                status = row[1]
                if not incorrectlyFreezedByStatus.__contains__(status):
                    incorrectlyFreezedByStatus[status] = []
                incorrectlyFreezedByStatus[status].append(str(ffwf_id))

            cur.close()
            conn.close()

            return incorrectlyFreezedByStatus
        except Exception as error:
            logging.info(error)
        finally:
            if cur is not None:
                cur.close()
            if conn is not None:
                conn.close()
            logging.info('FFWF database connection closed.')


    def on_execute(self):
        ssFreezedOutbounds = set(self.ssFreezedOutbounds())
        logging.info("Fetched " + str(len(ssFreezedOutbounds)) + " records from SS")
        incorrectlyFreezedByStatus = self.checkIncorrectlyFreezed(ssFreezedOutbounds)
        message = ''
        if len(incorrectlyFreezedByStatus) > 0:
            message = message + 'Найдено несколько изъятий, для которых присутствует некорректный фриз в СС\n\n'
            for status, incorrectlyFreezed in incorrectlyFreezedByStatus.iteritems():
                message = message + 'Найдено ' + str(len(incorrectlyFreezed)) + \
                          ' изъятий в статусе ' + str(status) + ':\n'
                message = message + ", ".join(set(incorrectlyFreezed)) + '\n\n'
        else:
            message = message + 'Не найдено некорректно зафриженных изъятий'


        bot = TelegramBot(bot_token=sdk2.Vault.data(self.Parameters.telegram_bot_token_vault_key))
        bot.send_message(self.Parameters.telegram_chat_id, message)
