# coding=utf-8

from sandbox import sdk2
from sandbox.sandboxsdk import environments


class InternalSaleOrderProcessing(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_url = sdk2.parameters.String('Startrack url', required=True)
        st_token_vault_key = sdk2.parameters.String('Startrack token vault key', required=True)
        st_assortment_queue = sdk2.parameters.String('Startrack assortment queue', required=True)
        st_order_queue = sdk2.parameters.String('Startrack order queue', required=True)

        assortment_sku_column = sdk2.parameters.Integer('Sku column in assortment file from 0', required=True)
        assortment_count_column = sdk2.parameters.Integer('Count column in assortment file from 0, -1 means all counts are 1', required=True)
        assortment_name_column = sdk2.parameters.Integer('Name column in assortment file from 0', required=True)
        assortment_price_column = sdk2.parameters.Integer('Price column in assortment file from 0', required=True)
        assortment_discount_percent_column = sdk2.parameters.Integer('Discount percent column in assortment file from 0', required=True)
        assortment_quality_column = sdk2.parameters.Integer('Quality column in assortment file from 0', required=True)
        assortment_shift_from_up = sdk2.parameters.Integer('Shift from upper border', required=True)

        wiki_oauth_token_vault_key = sdk2.parameters.String('Wiki OAuth token vault key', required=True)
        wiki_page_path = sdk2.parameters.String('Wiki page path', required=True)

        mds_s3_host=sdk2.parameters.String('S3 Host', required=True)
        mds_access_key_vault_key = sdk2.parameters.String('Mds access vault key', required=True)
        mds_secret_key_vault_key = sdk2.parameters.String('Mds secret vault key', required=True)
        mds_bucket_name=sdk2.parameters.String('Mds bucket name', required=True)
        mds_file_name=sdk2.parameters.String('Mds file name', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('openpyxl'),
                        environments.PipEnvironment('psycopg2-binary'),
                        environments.PipEnvironment("boto"),
                        environments.PipEnvironment('yandex_tracker_client', version="1.3", custom_parameters=["--upgrade-strategy only-if-needed"]),
                        environments.PipEnvironment('startrek_client', version="2.3.0", custom_parameters=["--upgrade-strategy only-if-needed"]))

    def get_available_assortment(self):
        from startrek_client import Startrek
        st = Startrek(useragent=self.Parameters.st_user_agent,
                      base_url=self.Parameters.st_url,
                      token=sdk2.Vault.data(self.Parameters.st_token_vault_key))
        issues = st.issues.find('Queue: ' + str(self.Parameters.st_assortment_queue) +
                                ' Status: Open' +
                                ' "Sort By": Key DESC',
                                per_page=1000
                                )
        if len(issues) > 1:
            i = 0
            for issue in issues:
                if i == len(issues) - 1:
                    break
                transition = issue.transitions['close']
                transition.execute(resolution=1)
                issue.comments.create(text='Не должно быть более одного открытого тикета в очереди %%' + str(self.Parameters.st_assortment_queue) + '%%, для смены ассортимента обратитесь в поддержку', summonees=issue.createdBy.login)
                i += 1
        issue = issues[len(issues) - 1]
        attachments = issue.attachments
        files = []
        for x in attachments:
            files.append(x)
        if len(files) > 1:
            issue.comments.create(text='Не должно быть более одного файла приложено к тикету, удалите лишние файлы', summonees=issue.createdBy.login)
            return None
        file = files[0]
        file.download_to('./')
        import openpyxl
        workbook = openpyxl.load_workbook(file.name)
        worksheet = workbook.active
        assortment = {}
        for i in range(self.Parameters.assortment_shift_from_up, worksheet.max_row):
            worksheet.iter_cols()
            sku = worksheet.cell(i, self.Parameters.assortment_sku_column).value
            name = worksheet.cell(i, self.Parameters.assortment_name_column).value
            price = worksheet.cell(i, self.Parameters.assortment_price_column).value
            discount_percent = worksheet.cell(i, self.Parameters.assortment_discount_percent_column).value
            quality = worksheet.cell(i, self.Parameters.assortment_quality_column).value
            count_index = self.Parameters.assortment_count_column
            if count_index == -1:
                count = 1
            else:
                count = worksheet.cell(i, count_index)
            discount_percent_float = float(discount_percent)
            actual_price = int(float(price) * discount_percent_float)
            assortment[sku] = (sku, name, quality, count, actual_price)

        order_issues = st.issues.find('Queue: ' + str(self.Parameters.st_order_queue) +
                                      ' Status: Open, Pending' +
                                      ' "Sort By": Key ASC',
                                      per_page=1000
                                      )
        for order_issue in order_issues:
            description = order_issue.description
            for line in description.splitlines():
                if line.startswith('sku:'):
                    sku = line[5:]
                    if not assortment.__contains__(sku):
                        transition = order_issue.transitions['close']
                        transition.execute(resolution=1)
                        order_issue.comments.create(text='В ассортименте нет такого товара, возможно, товар заполнен неверно.', summonees=order_issue.createdBy.login)
                        break
                    new_count = assortment[sku][3] - 1
                    if new_count < 0:
                        transition = order_issue.transitions['close']
                        transition.execute(resolution=1)
                        order_issue.comments.create(text='Извините, товар разобрали, он не будет доставлен.', summonees=order_issue.createdBy.login)
                        assortment.pop(sku)
                    else:
                        if order_issue.status.key != 'pending':
                            transition = order_issue.transitions['pending']
                            transition.execute()
                            order_issue.comments.create(text='Товар зарезервирован под заказ. Ждите коммуникацию в тикете.', summonees=order_issue.createdBy.login)
                            assortment[sku] = (assortment[sku][0], assortment[sku][1], assortment[sku][2], new_count, assortment[sku][4])
                            if new_count != 0:
                                assortment[sku] = (assortment[sku][0], assortment[sku][1], assortment[sku][2], new_count, assortment[sku][4])
                            else:
                                assortment.pop(sku)
                        else:
                            if new_count != 0:
                                assortment[sku] = (assortment[sku][0], assortment[sku][1], assortment[sku][2], new_count, assortment[sku][4])
                            else:
                                assortment.pop(sku)
        return assortment

    def create_files_with_assortment(self, assortment):
        from openpyxl import Workbook
        excel_data = []

        excel_data.append(['SKU', 'Название', 'Качество', 'Доступное количество', 'Цена'])
        for sku, params in assortment.items():
            excel_data.append([params[0], params[1], params[2], params[3], params[4]])
        wb = Workbook(write_only=True)
        ws = wb.create_sheet()
        for data in excel_data:
            ws.append(data)
        file_path = "actual_assortment.xlsx"
        wb.save(file_path)
        import csv
        with open('actual_assortment.csv', 'w') as file:
            wr = csv.writer(file)
            for data in excel_data:
                wr.writerow(data)

    def wiki_not_file_headers(self):
        return {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'Authorization': 'OAuth ' + sdk2.Vault.data(self.Parameters.wiki_oauth_token_vault_key)
        }

    def get_s3_connection(self):
        from boto.s3.connection import S3Connection

        return S3Connection(
            host=self.Parameters.mds_s3_host,
            aws_access_key_id=sdk2.Vault.data(self.Parameters.mds_access_key_vault_key),
            aws_secret_access_key=sdk2.Vault.data(self.Parameters.mds_secret_key_vault_key)
        )

    def attach_xlsx_assortment_file_to_s3_and_link_to_wiki(self, file_path):
        s3_connection = self.get_s3_connection()
        bucket = s3_connection.get_bucket(self.Parameters.mds_bucket_name)
        s3_path = self.Parameters.mds_file_name
        key = bucket.new_key(s3_path)

        key.set_contents_from_filename(file_path)

        s3_link = 'http://{}.{}/{}'.format(self.Parameters.mds_bucket_name, self.Parameters.mds_s3_host, self.Parameters.mds_file_name)

        wiki_url = 'https://wiki-api.yandex-team.ru/_api'
        import requests
        requests.post('{}/frontend/{}/'.format(wiki_url, self.Parameters.wiki_page_path), data=('{"title":"Продажи сотрудникам тестовая страница", "body": "((' + s3_link + '  Скачать доступный ассортимент))"}').encode('utf-8'), headers=self.wiki_not_file_headers())


    def on_execute(self):
        available_assortment = self.get_available_assortment()
        self.create_files_with_assortment(available_assortment)
        self.attach_xlsx_assortment_file_to_s3_and_link_to_wiki('actual_assortment.xlsx')
