# coding=utf-8

from sandbox import sdk2
from sandbox.sandboxsdk import environments
import logging


class InternalSaleOutboundFinalization(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_url = sdk2.parameters.String('Startrack url', required=True)
        st_token_vault_key = sdk2.parameters.String('Startrack token vault key', required=True)
        st_order_queue = sdk2.parameters.String('Startrack order queue', required=True)
        st_outbound_queue = sdk2.parameters.String('Startrack outbound queue', required=True)

        ffwf_database_user_vault_key = sdk2.parameters.String('FFWF databse user vault key',
                                                              required=True)
        ffwf_database_password_vault_key = sdk2.parameters.String('FFWF databse password vault key',
                                                                  required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('openpyxl'),
                        environments.PipEnvironment('psycopg2-binary'),
                        environments.PipEnvironment('yandex_tracker_client', version="1.3", custom_parameters=["--upgrade-strategy only-if-needed"]),
                        environments.PipEnvironment('startrek_client', version="2.3.0", custom_parameters=["--upgrade-strategy only-if-needed"]))

    def get_closed_outbound_tickets(self):
        from startrek_client import Startrek
        st = Startrek(useragent=self.Parameters.st_user_agent,
                      base_url=self.Parameters.st_url,
                      token=sdk2.Vault.data(self.Parameters.st_token_vault_key))
        return st.issues.find('Queue: ' + str(self.Parameters.st_outbound_queue) +
                                ' Status: Closed' +
                                ' "Sort By": Key DESC',
                                per_page=1000
                                )

    def get_ffwf_fact(self, ticket):
        outbound_id = None
        for comment in ticket.comments:
            if comment.text.startswith('Id изъятия:'):
                outbound_id = comment.text[11:].strip()
        if outbound_id is None:
            ticket.comments.create(text='Тикет закрыт, но в комментариях отсутствует идентификатор изъятия. Пожалуйста, добавьте комментарий в формате %%Id изъятия: {FFWF id}%%, пример: %%Id изъятия: 1234%%', summonees=ticket.createdBy.login)
            return None
        conn = None
        cur = None
        try:
            user = sdk2.Vault.data(self.Parameters.ffwf_database_user_vault_key)
            password = sdk2.Vault.data(self.Parameters.ffwf_database_password_vault_key)
            logging.info('Connecting to the FFWF database...')
            import psycopg2
            conn = psycopg2.connect(
                host="market-ff-workflow01f.db.yandex.net",
                port="6432",
                database="market_ff_workflow",
                user=user,
                password=password)
            logging.info('Connected')

            cur = conn.cursor()

            cur.execute("select ri.article, ri.fact_count, sr.status "
                        "from shop_request sr "
                        "join request_item ri on sr.id = ri.request_id "
                        "where sr.type = 1 and sr.id = " + str(outbound_id))
            raw_result = cur.fetchall()

            article_to_count = {}
            outbound_found = False
            for row in raw_result:
                outbound_found = True
                if row[2] == 10:
                    article_to_count[row[0]] = int(row[1])

            cur.close()
            conn.close()

            if not outbound_found:
                ticket.comments.create(text='Изъятие ' + str(outbound_id) + 'не найдено в FFWF. Пожалуйста, добавьте комментарий в формате %%Id изъятия: {FFWF id}%%, пример: %%Id изъятия: 1234%%', summonees=ticket.createdBy.login)
                return None
            return article_to_count
        except Exception as error:
            logging.info(error)
        finally:
            if cur is not None:
                cur.close()
            if conn is not None:
                conn.close()
            logging.info('FFWF database connection closed.')

    def get_order_sku(self, order_issue):
        description = order_issue.description
        for line in description.splitlines():
            if line.startswith('sku:'):
                return line[5:]

    def on_execute(self):
        closed_outbound_tickets = self.get_closed_outbound_tickets()
        from startrek_client import Startrek
        st = Startrek(useragent=self.Parameters.st_user_agent,
                      base_url=self.Parameters.st_url,
                      token=sdk2.Vault.data(self.Parameters.st_token_vault_key))
        not_closed_tickets = set()
        for ticket in closed_outbound_tickets:
            article_to_count = self.get_ffwf_fact(ticket)
            if article_to_count is None:
                continue
            links = ticket.links
            for link in links:
                key = link.object.key
                related_ticket = st.issues[key]
                if related_ticket.queue.key != self.Parameters.st_order_queue:
                    continue
                if related_ticket.status.key != 'pending':
                    continue
                sku = self.get_order_sku(related_ticket)
                if article_to_count.__contains__(sku):
                    count = article_to_count[sku]
                    if count > 0:
                        transition = related_ticket.transitions['inProgress']
                        transition.execute(resolution=1)
                        related_ticket.comments.create(text='Товар в пути.', summonees=related_ticket.createdBy.login)
                        if not_closed_tickets.__contains__(key):
                            not_closed_tickets.remove(key)
                        article_to_count[sku] = count - 1
                    else:
                        not_closed_tickets.add(key)
                else:
                    not_closed_tickets.add(key)
        for link in not_closed_tickets:
            ticket = st.issues[link]
            transition = ticket.transitions['closed']
            transition.execute(resolution=1)
            ticket.comments.create(text='Извините, товар разобрали, он не будет доставлен.', summonees=ticket.createdBy.login)
