# coding=utf-8

from sandbox import sdk2
from sandbox.sandboxsdk import environments


class InternalSaleOutboundGeneration(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_url = sdk2.parameters.String('Startrack url', required=True)
        st_token_vault_key = sdk2.parameters.String('Startrack token vault key', required=True)
        st_assortment_queue = sdk2.parameters.String('Startrack assortment queue', required=True)
        st_order_queue = sdk2.parameters.String('Startrack order queue', required=True)
        st_outbound_queue = sdk2.parameters.String('Startrack outbound queue', required=True)
        st_assignees = sdk2.parameters.String('Startrack assignees', required=True)

        assortment_sku_column = sdk2.parameters.Integer('Sku column in assortment file from 0', required=True)
        assortment_count_column = sdk2.parameters.Integer('Count column in assortment file from 0, -1 means all counts are 1', required=True)
        assortment_name_column = sdk2.parameters.Integer('Name column in assortment file from 0', required=True)
        assortment_price_column = sdk2.parameters.Integer('Price column in assortment file from 0', required=True)
        assortment_discount_percent_column = sdk2.parameters.Integer('Discount percent column in assortment file from 0', required=True)
        assortment_quality_column = sdk2.parameters.Integer('Quality column in assortment file from 0', required=True)
        assortment_shift_from_up = sdk2.parameters.Integer('Shift from upper border', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (environments.PipEnvironment('openpyxl'),
                        environments.PipEnvironment('psycopg2-binary'),
                        environments.PipEnvironment('yandex_tracker_client', version="1.3", custom_parameters=["--upgrade-strategy only-if-needed"]),
                        environments.PipEnvironment('startrek_client', version="2.3.0", custom_parameters=["--upgrade-strategy only-if-needed"]))

    def get_ordered_assortment(self):
        from startrek_client import Startrek
        st = Startrek(useragent=self.Parameters.st_user_agent,
                      base_url=self.Parameters.st_url,
                      token=sdk2.Vault.data(self.Parameters.st_token_vault_key))
        issues = st.issues.find('Queue: ' + str(self.Parameters.st_assortment_queue) +
                                ' Status: Open' +
                                ' "Sort By": Key DESC',
                                per_page=1000
                                )
        if len(issues) > 1:
            i = 0
            for issue in issues:
                if i == len(issues) - 1:
                    break
                transition = issue.transitions['close']
                transition.execute(resolution=1)
                issue.comments.create(text='Не должно быть более одного открытого тикета в очереди %%' + str(self.Parameters.st_assortment_queue) + '%%, для смены ассортимента обратитесь в поддержку', summonees=issue.createdBy.login)
                i += 1
        issue = issues[len(issues) - 1]
        attachments = issue.attachments
        files = []
        for x in attachments:
            files.append(x)
        if len(files) > 1:
            issue.comments.create(text='Не должно быть более одного файла приложено к тикету, удалите лишние файлы', summonees=issue.createdBy.login)
            return None
        file = files[0]
        file.download_to('./')
        import openpyxl
        workbook = openpyxl.load_workbook(file.name)
        worksheet = workbook.active
        assortment = {}
        for i in range(self.Parameters.assortment_shift_from_up, worksheet.max_row):
            worksheet.iter_cols()
            sku = worksheet.cell(i, self.Parameters.assortment_sku_column).value
            name = worksheet.cell(i, self.Parameters.assortment_name_column).value
            price = worksheet.cell(i, self.Parameters.assortment_price_column).value
            discount_percent = worksheet.cell(i, self.Parameters.assortment_discount_percent_column).value
            quality = worksheet.cell(i, self.Parameters.assortment_quality_column).value
            count_index = self.Parameters.assortment_count_column
            if count_index == -1:
                count = 1
            else:
                count = worksheet.cell(i, count_index)
            discount_percent_float = float(discount_percent)
            actual_price = int(float(price) * discount_percent_float)
            assortment[sku] = (sku, name, quality, count, actual_price)

        order_issues = st.issues.find('Queue: ' + str(self.Parameters.st_order_queue) +
                                      ' Status: Pending' +
                                      ' "Sort By": Key ASC',
                                      per_page=1000
                                      )
        outbound_plan = {}
        for order_issue in order_issues:
            description = order_issue.description
            for line in description.splitlines():
                if line.startswith('sku:'):
                    sku = line[5:]
                    if not assortment.__contains__(sku):
                        transition = order_issue.transitions['close']
                        transition.execute(resolution=1)
                        order_issue.comments.create(text='В ассортименте нет такого товара, возможно, товар заполнен неверно.', summonees=order_issue.createdBy.login)
                        break
                    new_count = assortment[sku][3] - 1
                    if new_count < 0:
                        transition = order_issue.transitions['close']
                        transition.execute(resolution=1)
                        order_issue.comments.create(text='Извините, товар разобрали, он не будет доставлен.', summonees=order_issue.createdBy.login)
                        assortment.pop(sku)
                    else:
                        if outbound_plan.__contains__(sku):
                            outbound_plan[sku] = (outbound_plan[sku][0] + 1, outbound_plan[sku][1], outbound_plan[sku][3].append(order_issue.key))
                        else:
                            outbound_plan[sku] = (1, assortment[sku][4], [order_issue.key])
                        assortment[sku] = (assortment[sku][0], assortment[sku][1], assortment[sku][2], new_count, assortment[sku][4])
        return outbound_plan

    def create_outbound_issue(self, outbound_plan):
        from openpyxl import Workbook
        excel_data = []

        links = []
        excel_data.append(['SSKU', 'Количество', 'Цена'])
        for sku, params in outbound_plan.items():
            excel_data.append([sku, params[0], params[1]])
            for link_key in params[2]:
                links.append({'relationship': 'relates', 'issue': link_key})
        wb = Workbook(write_only=True)
        ws = wb.create_sheet()
        for data in excel_data:
            ws.append(data)
        file_path = "outbound_plan.xlsx"
        wb.save(file_path)

        from startrek_client import Startrek
        st = Startrek(useragent=self.Parameters.st_user_agent,
                      base_url=self.Parameters.st_url,
                      token=sdk2.Vault.data(self.Parameters.st_token_vault_key))
        issue = st.issues.create(
            queue=str(self.Parameters.st_outbound_queue),
            summary='Изъятие продажи сотрудникам',
            description='Просьба создать изъятие в АХ для продажи уценки сотрудникам Яндекса по приложенному файлу.\nПосле этого просьба написать коммент в формате %%Id изъятия: {FFWF id}%%, пример: %%Id изъятия: 1234%%',
            attachments=['outbound_plan.xlsx'],
            links=links
        )
        issue.comments.create(text='Возьмите тикет в работу, пожалуйста', summonees=self.get_assignees())

    def get_assignees(self):
        result = []
        parts = self.Parameters.st_assignees.split(',')
        for part in parts:
            trimmed_part = part.strip()
            result.append(trimmed_part)
        return result

    def on_execute(self):
        outbound_plan = self.get_ordered_assortment()
        self.create_outbound_issue(outbound_plan)
