# coding=utf-8
import logging

import requests

import json

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.market.ff_wf_api.endpointToStartrackPusher.startrack_client_utils import create_or_update_tickets_from_endpoint_info


class EndpointToStartrackPusher(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        endpoint = sdk2.parameters.String('Url to get metrics from', required=True)
        startrack_queue = sdk2.parameters.String('Startrack queue', required=True)
        entity_name = sdk2.parameters.String('Entity name, e.g. поставки, заказы...', required=True)
        st_user_agent = sdk2.parameters.String('Startrack user agent', required=True)
        st_url = sdk2.parameters.String('Startrack url', required=True)
        st_token = sdk2.parameters.String('Startrack token', required=True)
        st_components = sdk2.parameters.String('Startrack components', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = [PipEnvironment('startrek_client')]

    def on_execute(self):
        data_from_endpoint = self.get_data_from_endpoint()
        supplier_to_data = data_from_endpoint['supplierToData']
        create_or_update_tickets_from_endpoint_info(self.Parameters.st_user_agent, self.Parameters.st_url,
                                                    self.Parameters.st_token, self.Parameters.startrack_queue,
                                                    self.Parameters.st_components, supplier_to_data,
                                                    self.Parameters.entity_name)

    def get_data_from_endpoint(self):
        data = requests.get(self.Parameters.endpoint)
        content = data.content
        logging.info('Got data ' + str(content) + ' from endpoint ' + str(self.Parameters.endpoint))
        return json.loads(content)
