# coding=utf-8
import codecs
import csv
import shutil
import tempfile
from datetime import datetime


def convert_file_encoding(filename, from_encoding, to_encoding):
    block_size = 102400
    new_filename = filename + ".new"
    with codecs.open(filename, "r", from_encoding) as sourceFile:
        with codecs.open(new_filename, "w", to_encoding) as targetFile:
            while True:
                contents = sourceFile.read(block_size)
                if not contents:
                    break
                targetFile.write(contents)
    shutil.move(new_filename, filename)


def split_and_strip(s, delim):
    if s is None:
        return ()
    parts = [p.strip() for p in str(s).split(delim)]
    if parts == ['']:
        return ()
    return parts


def comma_list(list):
    return ', '.join(list)


def generate_csv(mappings_for_csv):
    csv_file, csv_file_name = tempfile.mkstemp(prefix=datetime.now().strftime('%Y%m%d_%H%M%S_'), suffix=".csv")

    csv_cols_names = []
    for (name, value) in mappings_for_csv[0].iteritems():
        csv_cols_names.append(name)

    with open(csv_file_name, 'w') as fp:
        writer = csv.writer(fp, delimiter=';')
        writer.writerow(csv_cols_names)
        for mapping_for_csv in mappings_for_csv:
            row = []
            for (name, value) in mapping_for_csv.iteritems():
                row.append(value)
            writer.writerow(row)
    convert_file_encoding(csv_file_name, 'utf-8', 'cp1251')
    return csv_file_name
