# coding=utf-8

import codecs

from sandbox import sdk2

from sandbox.projects.market.ff_wf_api.loadTesting.createTrackerNotifyGenerator.create_tracker_notify_body_generator import generate_body_tracker_notify
from sandbox.projects.market.ff_wf_api.loadTesting.createWithdrawsGenerator.create_withdraws_ammos_list_generator import generate_withdraws_ammos_list
from sandbox.projects.market.ff_wf_api import AllFfwfOperationsAmmo, AllFfwfOperationsShootingConfig, \
    CancelAllInboundsAmmo
from sandbox.projects.market.ff_wf_api.loadTesting.ammo_generator import make_ammo
from sandbox.projects.market.ff_wf_api.loadTesting.constants import Constants
from sandbox.projects.market.ff_wf_api.loadTesting.createInboundGenerator.create_inbound_ammos_list_generator import \
    generate_ammos_list
from sandbox.projects.market.ff_wf_api.loadTesting.createInboundGenerator.create_inbound_skus_filter import \
    get_skus_for_create_inbound
from sandbox.projects.market.ff_wf_api.loadTesting.retrying_http_service import get_json
import random
from get_and_select_slot_splitter import split_on_get_and_select_slot
from slots_for_ammo_fetcher import fetch_slots_for_requests
from datetime import date, timedelta


class AllOperationsGenerator(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ffwf_url = sdk2.parameters.String('FFWF Url', required=True, default='http://ffw-api.tst.vs.market.yandex.net')
        items_in_last_item_request = sdk2.parameters.Integer('Items in last item request', default=100)
        cancel_all_inbounds = sdk2.parameters.Bool('Should cancel all params', required=True, default=False)
        items_in_inbounds = sdk2.parameters.Integer('Items in inbounds except one with all items', default=80)
        number_of_distinct_inbounds = sdk2.parameters.Integer('Number of distinct inbounds', default=20)
        shooting_length_minutes = sdk2.parameters.Integer('Shooting length in minutes', required=False, default=20)
        default_rps_config = sdk2.parameters.String('Default RPS config', required=False, default='0.15')
        method_rps_overrides = sdk2.parameters.String('String in format (methodTag, RPS)[;(methodTag, RPS)]')

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5

    class Constants:
        def __init__(self):
            pass

        LAST_ITEMS_BODY_TEMPLATE = '{"shopId":%d,"articles":[%s],"serviceIds":[' + Constants.WAREHOUSE + ']}'
        SELECT_SLOT_BODY_TEMPLATE = '{"date":"%s","from":"%s","to":"%s"}'
        UPDATING_REQUEST_BODY_TEMPLATE = '{"items":[%s]}'
        UPDATING_REQUEST_ITEMS_BODY_TEMPLATE = '{"article":"%s","count":3,"price":1.0,"unitId":{"parts":[%s]}}'
        UNIT_ID_PARTS_BODY_TEMPLATE = '{"type":"CIS","value":"CIS%d"}'
        COMMIT_SHADOW = '{"serviceId":' + Constants.WAREHOUSE + ',"requestedDate":"%s","from":"%s","to":"%s"}'
        SHOOTING_CONFIG_TEMPLATE = 'uploader:\n' \
                                   '  enabled: true\n' \
                                   '  task: BMP-2914\n' \
                                   '  api_address: https://lunapark.yandex-team.ru/\n' \
                                   '  job_name: BMP-2914\n' \
                                   '  operator: mslyusarenko\n' \
                                   '  package: yandextank.plugins.DataUploader\n\n' \
                                   '' \
                                   'neuploader:\n' \
                                   '  enabled: false\n' \
                                   '  package: yandextank.plugins.NeUploader\n\n' \
                                   '' \
                                   'autostop:\n' \
                                   '  enabled: true\n' \
                                   '  autostop: [\'time(25000ms,2m)\', \'http(5xx,10%%,2m)\']\n' \
                                   '  package: yandextank.plugins.Autostop\n' \
                                   '  report_file: autostop_report.txt\n\n' \
                                   '' \
                                   'phantom:\n' \
                                   '  enabled: true\n' \
                                   '  package: yandextank.plugins.Phantom\n' \
                                   '  timeout: 30s\n' \
                                   '  load_profile: {load_type: rps, schedule: \'const(%s,%dm)\'}\n'
        MULTI_SECTION_TEMPLATE = '  multi:\n%s'
        MULTI_ELEMENT_TEMPLATE = '    - chosen_cases: %s\n' \
                                 '      load_profile: {load_type: rps, schedule: \'const(%s,%dm)\'}\n'

    def on_execute(self):
        all_requests_json = get_json(self.Parameters.ffwf_url + '/load-testing/requests')
        shadow_supplies_with_items_count = []
        required_calendaring_supplies_with_items_count = []
        supplies_without_calendaring_ids = []
        supplies_with_confirmation = []
        all_supply_ids = []
        all_supplier_ids = set()
        supplier_for_request = {}
        for request_json in all_requests_json:
            request_id = request_json.get('id')
            sku_count = request_json.get('skuCount')
            all_supply_ids.append(request_id)
            supplier_id = request_json.get('shopId')
            supplier_for_request[request_id] = supplier_id
            all_supplier_ids.add(supplier_id)
            if request_json.get('type') == 8 and supplier_id != 10264169:  # Not first party
                shadow_supplies_with_items_count.append((sku_count, request_id))
            else:
                if request_json.get('type') == 8:
                    continue
                if request_json.get('status') == 12:
                    supplies_with_confirmation.append(request_id)
                    continue
                if request_json.get('calendaringMode') == 0:
                    required_calendaring_supplies_with_items_count.append((sku_count, request_id))
                else:
                    supplies_without_calendaring_ids.append(request_id)

        if self.Parameters.cancel_all_inbounds:
            generated_ammo = ''
            for request_id in all_supply_ids:
                supplier_id = supplier_for_request[request_id]
                generated_ammo += make_ammo(self.Parameters.ffwf_url, 'PUT',
                                            ('/suppliers/%d/requests/%d/cancel' % (supplier_id, request_id)),
                                            'cancelRequest', None)
            data = sdk2.ResourceData(CancelAllInboundsAmmo(self,
                                                           'Cancel all inbounds ammo',
                                                           'ffwf_cancel_all_inbounds.txt'))
            with codecs.open('ffwf_cancel_all_inbounds.txt', 'w', encoding='utf-8') as f:
                f.write(generated_ammo)
            data.ready()
            return

        get_and_select_slot_shadow_supplies = split_on_get_and_select_slot(shadow_supplies_with_items_count)
        get_and_select_slot_required_calendaring_supplies = \
            split_on_get_and_select_slot(required_calendaring_supplies_with_items_count)

        shadow_supplies_to_get_slot = get_and_select_slot_shadow_supplies[0]
        shadow_supplies_to_select_slot = get_and_select_slot_shadow_supplies[1]
        required_calendaring_supplies_to_get_slot = get_and_select_slot_required_calendaring_supplies[0]
        required_calendaring_supplies_to_select_slot = get_and_select_slot_required_calendaring_supplies[1]

        operations_ammos = []
        existing_tags = set()

        to_date = date.today()
        from_date = to_date - timedelta(days=90)
        to_date_iso = date.isoformat(to_date)
        from_date_iso = date.isoformat(from_date)
        operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                          (
                                              '/requests?types=0&serviceIds=' + Constants.WAREHOUSE +
                                              '&requestDateFrom=%s&requestDateTo=%s&size=100&page=3' % (
                                                  from_date_iso, to_date_iso)),
                                          'getRequests', None))
        existing_tags.add('getRequests')
        withdraws_ammos = []
        for request_id in all_supply_ids:
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                              ('/requests/%d' % request_id),
                                              'getRequestDetails', None))
            existing_tags.add('getRequestDetails')
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                              ('/requests/%d/items?size=100&page=0' % request_id),
                                              'getRequestItems', None))
            existing_tags.add('getRequestItems')
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                              (
                                                  '/requests/%d/items?hasDefects=false&hasSurplus=false&size=500'
                                                  '&requestId=%s&hasShortage=false&page=0' % (
                                                      request_id, request_id)),
                                              'getRequestItemsInfrequent', None))
            existing_tags.add('getRequestItemsInfrequent')

            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'POST', '/tracker/notify',
                                              'trackerNotify',
                                              generate_body_tracker_notify(request_id), None))
            existing_tags.add('trackerNotify')
            withdraws_ammos.extend(generate_withdraws_ammos_list(self.Parameters.ffwf_url, all_supplier_ids))
            # existing_tags.add('withdraws')

        operations_ammos.extend(withdraws_ammos)

        for supplier_id in all_supplier_ids:
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'POST',
                                              ('/suppliers/%d/last-items' % supplier_id),
                                              'getLastItems', self.generate_last_items_body(supplier_id)))
            existing_tags.add('getLastItems')

        for request_id in supplies_with_confirmation:
            request_items = get_json(self.Parameters.ffwf_url + '/requests/%d/items' % request_id)
            operations_ammos.append(
                make_ammo(self.Parameters.ffwf_url, 'PUT',
                          ('/requests/%d/items-update' % request_id),
                          'updatingRequest',
                          self.generate_updating_request_body(request_items.get('requestItems'))))
            existing_tags.add('updatingRequest')

        operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                          '/supply-limits/nearest-available-dates',
                                          'getNearestAvailableDates', None))
        existing_tags.add('getNearestAvailableDates')

        for request_id in supplies_without_calendaring_ids:
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'PUT',
                                              ('/requests/%d/cancel' % request_id),
                                              'cancelRequest', None))
            existing_tags.add('cancelRequest')
        today = date.today()
        for i in range(0, 20, 1):
            current_date = today + timedelta(days=i)
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                              ('/calendaring/' + Constants.WAREHOUSE + '/%s' % (
                                                  date.isoformat(current_date))),
                                              'getCalendaringInfo', None))
            existing_tags.add('getCalendaringInfo')

        for request_id in shadow_supplies_to_get_slot:
            supplier_id = supplier_for_request[request_id]
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                              ('/suppliers/%d/requests/%d/free-time-slots-by-service' %
                                               (supplier_id, request_id)),
                                              'getFreeTimeSlotsByService', None))
            existing_tags.add('getFreeTimeSlotsByService')

        for request_id in required_calendaring_supplies_to_get_slot:
            supplier_id = supplier_for_request[request_id]
            operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                              ('/suppliers/%d/requests/%d/getFreeTimeSlots' %
                                               (supplier_id, request_id)),
                                              'getFreeTimeSlots', None))
            existing_tags.add('getFreeTimeSlots')

        slots_for_requests = fetch_slots_for_requests(required_calendaring_supplies_to_select_slot,
                                                      shadow_supplies_to_select_slot, self.Parameters.ffwf_url)
        for slots_for_request in slots_for_requests:
            request_id = slots_for_request[0]
            request_date = slots_for_request[1]
            request_from_time = slots_for_request[2]
            request_to_time = slots_for_request[3]
            is_shadow = slots_for_request[4]
            if is_shadow:
                operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'POST',
                                                  ('/requests/%d/commit-shadow-supply' % request_id),
                                                  'commitShadowSupply',
                                                  self.generate_commit_shadow_supply(request_date,
                                                                                     request_from_time,
                                                                                     request_to_time)))
                existing_tags.add('commitShadowSupply')
            else:
                operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'POST',
                                                  ('/requests/%d/selectSlot' % request_id),
                                                  'bookSlot',
                                                  self.generate_select_slot_body(request_date,
                                                                                 request_from_time,
                                                                                 request_to_time)))
                existing_tags.add('bookSlot')

        operations_ammos.append(make_ammo(self.Parameters.ffwf_url, 'GET',
                                          '/reports/not-frozen-stocks?supplierId=10296179&serviceId=' + Constants.WAREHOUSE + '&stockType=0',
                                          'notFrozenStocksReport3p', None))
        existing_tags.add('notFrozenStocksReport3p')

        skus_for_create_1p_inbound = get_skus_for_create_inbound(self.Parameters.ffwf_url, True)
        skus_for_create_3p_inbound = get_skus_for_create_inbound(self.Parameters.ffwf_url, False)
        create_inbound_ammos = generate_ammos_list(self.Parameters.ffwf_url, self.Parameters.items_in_inbounds,
                                                   self.Parameters.number_of_distinct_inbounds,
                                                   skus_for_create_1p_inbound, skus_for_create_3p_inbound,
                                                   existing_tags)
        operations_ammos.extend(create_inbound_ammos)

        operations_ammo = self.get_ammo_string(operations_ammos)

        data = sdk2.ResourceData(AllFfwfOperationsAmmo(self,
                                                       'FFWF operations with inbound',
                                                       'ffwf_operations_with_inbound.txt'))
        with codecs.open('ffwf_operations_with_inbound.txt', 'w', encoding='utf-8') as f:
            f.write(operations_ammo)
        data.ready()

        shooting_config = self.Constants.SHOOTING_CONFIG_TEMPLATE % \
                          (self.Parameters.default_rps_config, self.Parameters.shooting_length_minutes)
        rps_overrides = self.get_tag_to_rps_override(self.Parameters.method_rps_overrides)
        multi_elements = ''
        for key in existing_tags:
            key_rps_config = self.Parameters.default_rps_config
            if key in rps_overrides:
                key_rps_config = rps_overrides[key]
            multi_elements += self.Constants.MULTI_ELEMENT_TEMPLATE % \
                              (key, key_rps_config, self.Parameters.shooting_length_minutes)

        if len(multi_elements) > 0:
            multi_section = self.Constants.MULTI_SECTION_TEMPLATE % multi_elements
            shooting_config += multi_section

        config_data = sdk2.ResourceData(AllFfwfOperationsShootingConfig(self,
                                                                        'FFWF operations with inbound config',
                                                                        'ffwf_operations_with_inbound_config.txt'))
        with codecs.open('ffwf_operations_with_inbound_config.txt', 'w', encoding='utf-8') as f:
            f.write(shooting_config)
        config_data.ready()

    def generate_last_items_body(self, supplier_id):
        skus = random.sample(Constants.SKUS_FOR_SUPPLIER, self.Parameters.items_in_last_item_request)
        skus_string = ','.join('"' + x + '"' for x in skus)
        return self.Constants.LAST_ITEMS_BODY_TEMPLATE % (supplier_id, skus_string)

    def generate_select_slot_body(self, request_date, request_from, request_to):
        return self.Constants.SELECT_SLOT_BODY_TEMPLATE % (request_date, request_from, request_to)

    def generate_commit_shadow_supply(self, request_date, request_from, request_to):
        return self.Constants.COMMIT_SHADOW % (request_date, request_from, request_to)

    def generate_updating_request_body(self, request_items):
        request_items_requests = []
        for i, request_item in enumerate(request_items):
            article = request_item.get('article')

            parts = []
            for j in range(3):
                parts.append(self.Constants.UNIT_ID_PARTS_BODY_TEMPLATE % (i * 3 + j))
            request_items_requests.append(
                self.Constants.UPDATING_REQUEST_ITEMS_BODY_TEMPLATE % (article, ','.join(parts)))

        return self.Constants.UPDATING_REQUEST_BODY_TEMPLATE % (','.join(request_items_requests))

    def get_ammo_string(self, ammos):
        random.shuffle(ammos)
        result = ''
        for ammo in ammos:
            result += ammo
        return result

    def get_tag_to_rps_override(self, tag_to_rps_override_string):
        if not tag_to_rps_override_string:
            return {}
        result = {}
        parts = tag_to_rps_override_string.split(';')
        for part in parts:
            trimmed_part = part[1:-1].strip()
            key_and_value = trimmed_part.split(',')
            trimmed_key = key_and_value[0].strip()
            trimmed_value = key_and_value[1].strip()
            result[trimmed_key] = trimmed_value
        return result
