# coding=utf-8

from sandbox.projects.market.ff_wf_api.loadTesting.request_validation_waiter import wait_for_request_validation
from sandbox.projects.market.ff_wf_api.loadTesting.retrying_http_service import get_json
from sandbox.projects.market.ff_wf_api.loadTesting.constants import Constants


def fetch_slots_for_requests(supply_ids, shadow_supply_ids, ffwf_url):
    max_taken_date = None
    max_taken_to_time = None
    date_time_for_supplies = []
    for request_id in supply_ids:
        try:
            wait_for_request_validation(ffwf_url, request_id)
            slots = get_json(ffwf_url + '/requests/' + str(request_id) + '/getFreeTimeSlots')
            if not slots or len(slots) == 0:
                continue
            maybe_taken_slot = find_taken_slot(max_taken_date, max_taken_to_time, slots)
            success = maybe_taken_slot[3]
            if success:
                max_taken_date = maybe_taken_slot[0]
                max_taken_to_time = maybe_taken_slot[2]
                date_time_for_supplies\
                    .append((request_id, maybe_taken_slot[0], maybe_taken_slot[1], maybe_taken_slot[2], False))
        except Exception:
            pass
    for request_id in shadow_supply_ids:
        try:
            wait_for_request_validation(ffwf_url, request_id)
            slots_by_service = get_json(ffwf_url + '/requests/' + str(request_id) + '/free-time-slots-by-service')
            if not slots_by_service:
                continue
            slots = None
            for by_service in slots_by_service:
                if by_service.get('serviceId') == int(Constants.WAREHOUSE):
                    slots = by_service.get('freeSlots')
            if not slots or len(slots) == 0:
                continue
            maybe_taken_slot = find_taken_slot(max_taken_date, max_taken_to_time, slots)
            success = maybe_taken_slot[3]
            if success:
                max_taken_date = maybe_taken_slot[0]
                max_taken_to_time = maybe_taken_slot[2]
                date_time_for_supplies\
                    .append((request_id, maybe_taken_slot[0], maybe_taken_slot[1], maybe_taken_slot[2], True))
        except Exception:
            pass
    return date_time_for_supplies


def find_taken_slot(max_taken_date, max_taken_to_time, slots):
    try_take_result = find_min_greater_or_equal_for_slots(max_taken_date, max_taken_to_time, slots, True)
    find_from_beginning = try_take_result[3]
    find_on_next_day = try_take_result[4]
    if not find_from_beginning and not find_on_next_day:
        return try_take_result[0], try_take_result[1], try_take_result[2], True
    else:
        if find_on_next_day:
            try_take_result_again = \
                find_min_greater_or_equal_for_slots(max_taken_date, max_taken_to_time, slots, False)
            taken_date = try_take_result_again[0]
            if taken_date:
                return taken_date, try_take_result_again[1], try_take_result_again[2], True
            else:
                find_from_beginning = True
        if find_from_beginning:
            try_take_from_beginning_result = \
                find_min_greater_or_equal_for_slots(None, None, slots, True)
            taken_date = try_take_from_beginning_result[0]
            if taken_date:
                return taken_date, try_take_from_beginning_result[1], try_take_from_beginning_result[2], True
            else:
                return None, None, None, False


def find_min_greater_or_equal_for_slots(max_taken_date, max_taken_to_time, slots, greater_or_equal_date):
    min_greater_or_equal_date = find_min_greater(slots, 'day', max_taken_date, greater_or_equal_date)
    find_from_beginning = False
    find_on_next_day = False
    taken_date = None
    taken_from_time = None
    taken_to_time = None
    if not min_greater_or_equal_date:
        find_from_beginning = True
    else:
        if min_greater_or_equal_date.get('day') == max_taken_date:
            min_greater_or_equal_time = \
                find_min_greater(min_greater_or_equal_date.get('slots'), 'from', max_taken_to_time, True)
            if not min_greater_or_equal_time:
                find_on_next_day = True
            else:
                taken_date = min_greater_or_equal_date.get('day')
                taken_from_time = min_greater_or_equal_time.get('from')
                taken_to_time = min_greater_or_equal_time.get('to')
        else:
            min_greater_or_equal_time = \
                find_min_greater(min_greater_or_equal_date.get('slots'), 'from', None, True)
            taken_date = min_greater_or_equal_date.get('day')
            taken_from_time = min_greater_or_equal_time.get('from')
            taken_to_time = min_greater_or_equal_time.get('to')
    return taken_date, taken_from_time, taken_to_time, find_from_beginning, find_on_next_day


def find_min_greater(json_array, field_name, lower_bound, greater_or_equal):
    min_greater = None
    result_element = None
    for element in json_array:
        value = element.get(field_name)
        if greater_or_equal:
            if not lower_bound or value >= lower_bound:
                if not min_greater or min_greater > value:
                    min_greater = value
                    result_element = element
        else:
            if not lower_bound or value > lower_bound:
                if not min_greater or min_greater > value:
                    min_greater = value
                    result_element = element
    return result_element
