# coding=utf-8
# util method for generating ammo
try:
    from urllib.parse import urlparse
except ImportError:
    from urlparse import urlparse


def make_ammo(host, http_method, url, tag, body, additional_headers=None):
    """
        Makes phantom ammo
        http://yandextank.readthedocs.org/en/latest/ammo_generators.html
    """

    req_with_headers = "%s %s HTTP/1.1\r\n"
    headers = generate_headers(host, body)
    for header in headers:
        req_with_headers = req_with_headers + header + "\r\n"
    if additional_headers:
        for header in additional_headers:
            req_with_headers = req_with_headers + header + "\r\n"

    if not body:
        req_template_without_body = req_with_headers + "\r\n"
        req = req_template_without_body % (http_method, url)
    else:
        req_template_with_body = req_with_headers + "\r\n" + "%s\r\n\r\n"
        req = req_template_with_body % (http_method, url, body)

    # phantom ammo template
    ammo_template = (
        "%d %s\n"
        "%s\n"
    )

    return ammo_template % (len(req.encode('utf-8')), tag, req)


def generate_headers(host, body):
    if body:
        body_length = len(body.encode('utf-8'))
    else:
        body_length = 0
    return ['Host: ' + urlparse(host).hostname, 'User-Agent: tank', 'Accept: */*', 'Content-Length: ' + str(body_length),
            'Content-Type: application/json']
