# coding=utf-8

from sandbox import sdk2

from sandbox.projects.market.ff_wf_api import CreateCrossdockOrdersAmmo
from sandbox.projects.market.ff_wf_api.loadTesting.ammo_generator import make_ammo
import codecs

from report_client import get_crossdock_offer
from checkouter_client import cart, make_checkout_request


class CreateCrossdockOrdersAmmoGenerator(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        report_url = sdk2.parameters.String('Report Url', required=True,
                                            default='http://warehouse-report.blue.tst.vs.market.yandex.net:17051')
        checkouter_url = sdk2.parameters.String('Checkouter Url', required=True,
                                                default='https://checkouter.tst.vs.market.yandex.net:39011')

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5

    def on_execute(self):
        offer = get_crossdock_offer(self.Parameters.report_url)
        delivery_info = cart(self.Parameters.checkouter_url, offer)
        checkout_request = make_checkout_request(delivery_info)
        checkout_url = checkout_request[0]
        checkout_body = checkout_request[1]
        additional_headers = checkout_request[2]
        checkout_ammo = make_ammo(self.Parameters.checkouter_url, 'POST', checkout_url, 'createCrossdockOrder',
                                  checkout_body, additional_headers)
        data = sdk2.ResourceData(CreateCrossdockOrdersAmmo(self,
                                                           'Create crossdock order ammo',
                                                           'create_crossdock_orders_ammo.txt'))
        with codecs.open('create_crossdock_orders_ammo.txt', 'w', encoding='utf-8') as f:
            f.write(checkout_ammo)
        data.ready()
